/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.sshd.common.util.GenericUtils;

public final class ReflectionUtils {
    public static final Function<Field, String> FIELD_NAME_EXTRACTOR = f2 -> f2 == null ? null : f2.getName();

    private ReflectionUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static Collection<Field> getMatchingFields(Class<?> clazz, Predicate<? super Field> acceptor) {
        return GenericUtils.selectMatchingMembers(acceptor, clazz.getFields());
    }

    public static Collection<Field> getMatchingDeclaredFields(Class<?> clazz, Predicate<? super Field> acceptor) {
        return GenericUtils.selectMatchingMembers(acceptor, clazz.getDeclaredFields());
    }

    @Deprecated
    public static boolean isClassAvailable(ClassLoader cl, String className) {
        try {
            cl.loadClass(className);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static Object newInstance(Class<?> clazz) throws ReflectiveOperationException {
        return ReflectionUtils.newInstance(clazz, Object.class);
    }

    public static <T> T newInstance(Class<?> clazz, Class<? extends T> castType) throws ReflectiveOperationException {
        Constructor<?> ctor = clazz.getDeclaredConstructor(new Class[0]);
        Object instance = ctor.newInstance(new Object[0]);
        return castType.cast(instance);
    }
}

