/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.io.File;
import java.nio.file.FileSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class SelectorUtils {
    public static final String PATTERN_HANDLER_PREFIX = "[";
    public static final String PATTERN_HANDLER_SUFFIX = "]";
    public static final String REGEX_HANDLER_PREFIX = "%regex[";
    public static final String ANT_HANDLER_PREFIX = "%ant[";

    private SelectorUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static boolean matchPatternStart(String pattern2, String str) {
        return SelectorUtils.matchPatternStart(pattern2, str, true);
    }

    public static boolean matchPatternStart(String pattern2, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern2, str, File.separator, isCaseSensitive);
    }

    public static boolean matchPatternStart(String pattern2, String str, String separator, boolean isCaseSensitive) {
        if (pattern2.length() > REGEX_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern2.startsWith(REGEX_HANDLER_PREFIX) && pattern2.endsWith(PATTERN_HANDLER_SUFFIX)) {
            return true;
        }
        if (pattern2.length() > ANT_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern2.startsWith(ANT_HANDLER_PREFIX) && pattern2.endsWith(PATTERN_HANDLER_SUFFIX)) {
            pattern2 = pattern2.substring(ANT_HANDLER_PREFIX.length(), pattern2.length() - PATTERN_HANDLER_SUFFIX.length());
        }
        if (SelectorUtils.matchAntPathPatternStart(pattern2, str, separator, isCaseSensitive)) {
            return true;
        }
        return SelectorUtils.matchAntPathPatternStart(pattern2, str.replace('\\', '/'), "/", isCaseSensitive);
    }

    public static boolean matchAntPathPatternStart(String pattern2, String str, String separator, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        if (str.startsWith(separator) != pattern2.startsWith(separator)) {
            return false;
        }
        List<String> patDirs = SelectorUtils.tokenizePath(pattern2, separator);
        List<String> strDirs = SelectorUtils.tokenizePath(str, separator);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.size() - 1;
        int strIdxEnd = strDirs.size() - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs.get(patIdxStart)).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (SelectorUtils.match(patDir, strDirs.get(strIdxStart), isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            return true;
        }
        return patIdxStart <= patIdxEnd;
    }

    public static boolean matchPath(String pattern2, String str) {
        return SelectorUtils.matchPath(pattern2, str, true);
    }

    public static boolean matchPath(String pattern2, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern2, str, File.separator, isCaseSensitive);
    }

    public static boolean matchPath(String pattern2, String str, String separator, boolean isCaseSensitive) {
        if (pattern2.length() > REGEX_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern2.startsWith(REGEX_HANDLER_PREFIX) && pattern2.endsWith(PATTERN_HANDLER_SUFFIX)) {
            pattern2 = pattern2.substring(REGEX_HANDLER_PREFIX.length(), pattern2.length() - PATTERN_HANDLER_SUFFIX.length());
            return str.matches(pattern2);
        }
        if (pattern2.length() > ANT_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern2.startsWith(ANT_HANDLER_PREFIX) && pattern2.endsWith(PATTERN_HANDLER_SUFFIX)) {
            pattern2 = pattern2.substring(ANT_HANDLER_PREFIX.length(), pattern2.length() - PATTERN_HANDLER_SUFFIX.length());
        }
        return SelectorUtils.matchAntPathPattern(pattern2, str, separator, isCaseSensitive);
    }

    public static boolean matchAntPathPattern(String pattern2, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchAntPathPattern(pattern2, str, File.separator, isCaseSensitive);
    }

    public static boolean matchAntPathPattern(String pattern2, String str, String separator, boolean isCaseSensitive) {
        String subPat;
        String subDir;
        String patDir;
        int strIdxStart;
        if (str.startsWith(separator) != pattern2.startsWith(separator)) {
            return false;
        }
        List<String> patDirs = SelectorUtils.tokenizePath(pattern2, separator);
        List<String> strDirs = SelectorUtils.tokenizePath(str, separator);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.size() - 1;
        int strIdxEnd = strDirs.size() - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs.get(patIdxStart)).equals("**"); ++patIdxStart, ++strIdxStart) {
            subDir = strDirs.get(strIdxStart);
            if (SelectorUtils.match(patDir, subDir, isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                subPat = patDirs.get(i2);
                if (subPat.equals("**")) continue;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs.get(patIdxEnd)).equals("**")) {
            subDir = strDirs.get(strIdxEnd);
            if (!SelectorUtils.match(patDir, subDir, isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i3 = patIdxStart; i3 <= patIdxEnd; ++i3) {
                subPat = patDirs.get(i3);
                if (subPat.equals("**")) continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i4 = patIdxStart + 1; i4 <= patIdxEnd; ++i4) {
                String subPat2 = patDirs.get(i4);
                if (!subPat2.equals("**")) continue;
                patIdxTmp = i4;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i5 = 0; i5 <= strLength - patLength; ++i5) {
                for (int j2 = 0; j2 < patLength; ++j2) {
                    String subStr;
                    String subPat3 = patDirs.get(patIdxStart + j2 + 1);
                    if (!SelectorUtils.match(subPat3, subStr = strDirs.get(strIdxStart + i5 + j2), isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i5;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i6 = patIdxStart; i6 <= patIdxEnd; ++i6) {
            String subPat4 = patDirs.get(i6);
            if (subPat4.equals("**")) continue;
            return false;
        }
        return true;
    }

    public static boolean match(String pattern2, String str) {
        return SelectorUtils.match(pattern2, str, true);
    }

    public static boolean match(String pattern2, String str, boolean isCaseSensitive) {
        char ch;
        char[] patArr = pattern2.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (char aPatArr : patArr) {
            if (aPatArr != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (int i2 = 0; i2 <= patIdxEnd; ++i2) {
                char ch2 = patArr[i2];
                if (ch2 == '?' || SelectorUtils.equals(ch2, strArr[i2], isCaseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxStart], isCaseSensitive)) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i3 = patIdxStart; i3 <= patIdxEnd; ++i3) {
                if (patArr[i3] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i4 = patIdxStart; i4 <= patIdxEnd; ++i4) {
                if (patArr[i4] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i5 = patIdxStart + 1; i5 <= patIdxEnd; ++i5) {
                if (patArr[i5] != '*') continue;
                patIdxTmp = i5;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i6 = 0; i6 <= strLength - patLength; ++i6) {
                for (int j2 = 0; j2 < patLength; ++j2) {
                    ch = patArr[patIdxStart + j2 + 1];
                    if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxStart + i6 + j2], isCaseSensitive)) continue block8;
                }
                foundIdx = strIdxStart + i6;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i7 = patIdxStart; i7 <= patIdxEnd; ++i7) {
            if (patArr[i7] == '*') continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char c1, char c2, boolean isCaseSensitive) {
        if (c1 == c2) {
            return true;
        }
        return !isCaseSensitive && (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2));
    }

    public static List<String> tokenizePath(String path2) {
        return SelectorUtils.tokenizePath(path2, File.separator);
    }

    public static List<String> tokenizePath(String path2, String separator) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path2, separator);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret;
    }

    public static String translateToLocalFileSystemPath(String path2, char pathSeparator, FileSystem fs) {
        return SelectorUtils.translateToLocalFileSystemPath(path2, pathSeparator, Objects.requireNonNull(fs, "No target file system").getSeparator());
    }

    public static String translateToLocalFileSystemPath(String path2, char pathSeparator, String fsSeparator) {
        String slashified = SelectorUtils.applySlashifyRules(path2, pathSeparator);
        String localPath = SelectorUtils.translateToLocalPath(slashified);
        return SelectorUtils.translateToFileSystemPath(localPath, File.separator, fsSeparator);
    }

    public static String applySlashifyRules(String path2, char sepChar) {
        if (GenericUtils.isEmpty(path2)) {
            return path2;
        }
        int curPos = path2.indexOf(sepChar);
        if (curPos < 0) {
            return path2;
        }
        int lastPos = 0;
        StringBuilder sb = null;
        while (curPos < path2.length()) {
            int nextPos;
            for (nextPos = ++curPos; nextPos < path2.length() && path2.charAt(nextPos) == sepChar; ++nextPos) {
            }
            int seqLen = nextPos - curPos;
            if (seqLen > 0) {
                if (sb == null) {
                    sb = new StringBuilder(path2.length() - seqLen);
                }
                if (lastPos < curPos) {
                    String clrText = path2.substring(lastPos, curPos);
                    sb.append(clrText);
                }
                lastPos = nextPos;
            }
            if (nextPos < path2.length() && (curPos = path2.indexOf(sepChar, nextPos)) >= nextPos) continue;
            break;
        }
        if (sb != null) {
            if (lastPos < path2.length()) {
                String clrText = path2.substring(lastPos);
                sb.append(clrText);
            }
            path2 = sb.toString();
        }
        if (path2.length() > 1 && path2.charAt(path2.length() - 1) == sepChar) {
            return path2 + ".";
        }
        return path2;
    }

    public static String translateToLocalPath(String path2) {
        if (GenericUtils.isEmpty(path2) || File.separatorChar == '/') {
            return path2;
        }
        String localPath = path2.replace('/', File.separatorChar);
        if (localPath.charAt(0) == File.separatorChar && SelectorUtils.isWindowsDriveSpecified(localPath, 1, localPath.length() - 1)) {
            localPath = localPath.substring(1);
        }
        if (!SelectorUtils.isWindowsDriveSpecified(localPath)) {
            return localPath;
        }
        if (localPath.length() == 2) {
            return localPath + File.separator;
        }
        if (localPath.charAt(2) != File.separatorChar) {
            return localPath.substring(0, 2) + File.separator + localPath.substring(2);
        }
        return localPath;
    }

    public static boolean isWindowsDriveSpecified(CharSequence cs) {
        return SelectorUtils.isWindowsDriveSpecified(cs, 0, GenericUtils.length(cs));
    }

    public static boolean isWindowsDriveSpecified(CharSequence cs, int offset, int len2) {
        if (len2 < 2 || cs.charAt(offset + 1) != ':') {
            return false;
        }
        char drive = cs.charAt(offset);
        return drive >= 'a' && drive <= 'z' || drive >= 'A' && drive <= 'Z';
    }

    public static String translateToFileSystemPath(String path2, String pathSeparator, FileSystem fs) {
        return SelectorUtils.translateToFileSystemPath(path2, pathSeparator, Objects.requireNonNull(fs, "No target file system").getSeparator());
    }

    public static String translateToFileSystemPath(String path2, String pathSeparator, String fsSeparator) {
        ValidateUtils.checkNotNullAndNotEmpty(pathSeparator, "Missing path separator");
        ValidateUtils.checkNotNullAndNotEmpty(fsSeparator, "Missing file-system separator");
        if (GenericUtils.isEmpty(path2) || Objects.equals(pathSeparator, fsSeparator)) {
            return path2;
        }
        if (path2.contains(fsSeparator)) {
            ValidateUtils.throwIllegalArgumentException("File system replacement may yield ambiguous result for %s with separator=%s", path2, fsSeparator);
        }
        if (pathSeparator.length() == 1 && fsSeparator.length() == 1) {
            return path2.replace(pathSeparator.charAt(0), fsSeparator.charAt(0));
        }
        return path2.replace(pathSeparator, fsSeparator);
    }

    public static String concatPaths(String p1, String p2, char fsSeparator) {
        if (GenericUtils.isEmpty(p1)) {
            return p2;
        }
        if (GenericUtils.isEmpty(p2)) {
            return p1;
        }
        if (p1.charAt(p1.length() - 1) == fsSeparator) {
            if (p2.charAt(0) == fsSeparator) {
                return p2.length() == 1 ? p1 : p1 + p2.substring(1);
            }
            return p1 + p2;
        }
        if (p2.charAt(0) == fsSeparator) {
            return p2.length() == 1 ? p1 : p1 + p2;
        }
        return p1 + Character.toString(fsSeparator) + p2;
    }

    public static String removeWhitespace(String input) {
        StringBuilder result2 = new StringBuilder();
        if (input != null) {
            StringTokenizer st = new StringTokenizer(input);
            while (st.hasMoreTokens()) {
                result2.append(st.nextToken());
            }
        }
        return result2.toString();
    }
}

