/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.NumberUtils;

public final class ValidateUtils {
    private ValidateUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static <T> T checkNotNull(T t2, String message) {
        ValidateUtils.checkTrue(t2 != null, message);
        return t2;
    }

    public static <T> T checkNotNull(T t2, String message, Object arg) {
        ValidateUtils.checkTrue(t2 != null, message, arg);
        return t2;
    }

    public static <T> T checkNotNull(T t2, String message, long value2) {
        ValidateUtils.checkTrue(t2 != null, message, value2);
        return t2;
    }

    public static <T> T checkNotNull(T t2, String message, Object ... args2) {
        ValidateUtils.checkTrue(t2 != null, message, args2);
        return t2;
    }

    public static String hasContent(String t2, String message) {
        if (t2 == null || t2.isEmpty()) {
            ValidateUtils.throwIllegalArgumentException(message, new Object[0]);
        }
        return t2;
    }

    public static String hasContent(String t2, String message, Object arg) {
        if (t2 == null || t2.isEmpty()) {
            ValidateUtils.throwIllegalArgumentException(message, arg);
        }
        return t2;
    }

    public static String hasContent(String t2, String message, Object ... args2) {
        if (t2 == null || t2.isEmpty()) {
            ValidateUtils.throwIllegalArgumentException(message, args2);
        }
        return t2;
    }

    public static String checkNotNullAndNotEmpty(String t2, String message) {
        ValidateUtils.checkTrue(GenericUtils.length(t2 = ValidateUtils.checkNotNull(t2, message).trim()) > 0, message);
        return t2;
    }

    public static String checkNotNullAndNotEmpty(String t2, String message, Object arg) {
        ValidateUtils.checkTrue(GenericUtils.length(t2 = ValidateUtils.checkNotNull(t2, message, arg).trim()) > 0, message, arg);
        return t2;
    }

    public static String checkNotNullAndNotEmpty(String t2, String message, Object ... args2) {
        ValidateUtils.checkTrue(GenericUtils.length(t2 = ValidateUtils.checkNotNull(t2, message, args2).trim()) > 0, message, args2);
        return t2;
    }

    public static <K, V, M extends Map<K, V>> M checkNotNullAndNotEmpty(M t2, String message, Object ... args2) {
        ValidateUtils.checkNotNull(t2, message, args2);
        ValidateUtils.checkTrue(MapEntryUtils.size(t2) > 0, message, args2);
        return t2;
    }

    public static <T, C extends Collection<T>> C checkNotNullAndNotEmpty(C t2, String message, Object ... args2) {
        ValidateUtils.checkNotNull(t2, message, args2);
        ValidateUtils.checkTrue(GenericUtils.size(t2) > 0, message, args2);
        return t2;
    }

    public static <T, C extends Iterable<T>> C checkNotNullAndNotEmpty(C t2, String message, Object ... args2) {
        ValidateUtils.checkNotNull(t2, message, args2);
        ValidateUtils.checkTrue(GenericUtils.isNotEmpty(t2), message, args2);
        return t2;
    }

    public static byte[] checkNotNullAndNotEmpty(byte[] a2, String message) {
        ValidateUtils.checkNotNull(a2, message);
        ValidateUtils.checkTrue(NumberUtils.length(a2) > 0, message);
        return a2;
    }

    public static byte[] checkNotNullAndNotEmpty(byte[] a2, String message, Object ... args2) {
        ValidateUtils.checkNotNull(a2, message, args2);
        ValidateUtils.checkTrue(NumberUtils.length(a2) > 0, message, args2);
        return a2;
    }

    public static char[] checkNotNullAndNotEmpty(char[] a2, String message) {
        ValidateUtils.checkNotNull(a2, message);
        ValidateUtils.checkTrue(GenericUtils.length(a2) > 0, message);
        return a2;
    }

    public static char[] checkNotNullAndNotEmpty(char[] a2, String message, Object ... args2) {
        ValidateUtils.checkNotNull(a2, message, args2);
        ValidateUtils.checkTrue(GenericUtils.length(a2) > 0, message, args2);
        return a2;
    }

    public static int[] checkNotNullAndNotEmpty(int[] a2, String message) {
        ValidateUtils.checkNotNull(a2, message);
        ValidateUtils.checkTrue(NumberUtils.length(a2) > 0, message);
        return a2;
    }

    public static int[] checkNotNullAndNotEmpty(int[] a2, String message, Object ... args2) {
        ValidateUtils.checkNotNull(a2, message, args2);
        ValidateUtils.checkTrue(NumberUtils.length(a2) > 0, message, args2);
        return a2;
    }

    public static <T> T[] checkNotNullAndNotEmpty(T[] t2, String message, Object ... args2) {
        ValidateUtils.checkNotNull(t2, message, args2);
        ValidateUtils.checkTrue(GenericUtils.length(t2) > 0, message, args2);
        return t2;
    }

    public static <T> T checkInstanceOf(Object v, Class<T> expected, String message, long value2) {
        Class<?> actual = ValidateUtils.checkNotNull(v, message, value2).getClass();
        ValidateUtils.checkTrue(expected.isAssignableFrom(actual), message, value2);
        return expected.cast(v);
    }

    public static <T> T checkInstanceOf(Object v, Class<T> expected, String message) {
        return ValidateUtils.checkInstanceOf(v, expected, message, GenericUtils.EMPTY_OBJECT_ARRAY);
    }

    public static <T> T checkInstanceOf(Object v, Class<T> expected, String message, Object arg) {
        Class<?> actual = ValidateUtils.checkNotNull(v, message, arg).getClass();
        ValidateUtils.checkTrue(expected.isAssignableFrom(actual), message, arg);
        return expected.cast(v);
    }

    public static <T> T checkInstanceOf(Object v, Class<T> expected, String message, Object ... args2) {
        Class<?> actual = ValidateUtils.checkNotNull(v, message, args2).getClass();
        ValidateUtils.checkTrue(expected.isAssignableFrom(actual), message, args2);
        return expected.cast(v);
    }

    public static void checkTrue(boolean flag, String message) {
        if (!flag) {
            ValidateUtils.throwIllegalArgumentException(message, GenericUtils.EMPTY_OBJECT_ARRAY);
        }
    }

    public static void checkTrue(boolean flag, String message, long value2) {
        if (!flag) {
            ValidateUtils.throwIllegalArgumentException(message, value2);
        }
    }

    public static void checkTrue(boolean flag, String message, Object arg) {
        if (!flag) {
            ValidateUtils.throwIllegalArgumentException(message, arg);
        }
    }

    public static void checkTrue(boolean flag, String message, Object ... args2) {
        if (!flag) {
            ValidateUtils.throwIllegalArgumentException(message, args2);
        }
    }

    public static void throwIllegalArgumentException(String format2, Object ... args2) {
        throw ValidateUtils.createFormattedException(IllegalArgumentException::new, format2, args2);
    }

    public static void checkState(boolean flag, String message) {
        if (!flag) {
            ValidateUtils.throwIllegalStateException(message, GenericUtils.EMPTY_OBJECT_ARRAY);
        }
    }

    public static void checkState(boolean flag, String message, long value2) {
        if (!flag) {
            ValidateUtils.throwIllegalStateException(message, value2);
        }
    }

    public static void checkState(boolean flag, String message, Object arg) {
        if (!flag) {
            ValidateUtils.throwIllegalStateException(message, arg);
        }
    }

    public static void checkState(boolean flag, String message, Object ... args2) {
        if (!flag) {
            ValidateUtils.throwIllegalStateException(message, args2);
        }
    }

    public static void throwIllegalStateException(String format2, Object ... args2) {
        throw ValidateUtils.createFormattedException(IllegalStateException::new, format2, args2);
    }

    public static <T extends Throwable> T createFormattedException(Function<? super String, ? extends T> constructor, String format2, Object ... args2) {
        String message = String.format(format2, args2);
        return (T)((Throwable)constructor.apply(message));
    }

    public static <T extends Throwable> T initializeExceptionCause(T err, Throwable cause) {
        if (cause == null) {
            return err;
        }
        if (err.getCause() != null) {
            return err;
        }
        err.initCause(cause);
        return err;
    }
}

