/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.function.IntUnaryOperator;
import java.util.logging.Level;
import org.apache.sshd.common.CommonModuleProperties;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.SimplifiedLog;

public final class BufferUtils {
    public static final char DEFAULT_HEX_SEPARATOR = ' ';
    public static final char EMPTY_HEX_SEPARATOR = '\u0000';
    public static final String HEX_DIGITS = "0123456789abcdef";
    public static final Level DEFAULT_HEXDUMP_LEVEL = Level.FINEST;
    public static final IntUnaryOperator DEFAULT_BUFFER_GROWTH_FACTOR = BufferUtils::getNextPowerOf2;
    public static final long MAX_UINT32_VALUE = 0xFFFFFFFFL;
    public static final int MAX_UINT8_VALUE = 255;

    private BufferUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static int indexOf(byte[] array, byte valueToFind, int startIndex, int len2) {
        if (array == null) {
            return -1;
        }
        int i2 = Math.max(startIndex, 0);
        for (int l = 0; l < len2; ++l) {
            if (valueToFind == array[i2]) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public static void dumpHex(SimplifiedLog logger, Level level, String prefix2, PropertyResolver resolver, char sep, byte ... data2) {
        BufferUtils.dumpHex(logger, level, prefix2, resolver, sep, data2, 0, NumberUtils.length(data2));
    }

    public static void dumpHex(SimplifiedLog logger, Level level, String prefix2, PropertyResolver resolver, char sep, byte[] data2, int offset, int len2) {
        BufferUtils.dumpHex(logger, level, prefix2, sep, (int)CommonModuleProperties.HEXDUMP_CHUNK_SIZE.getRequired(resolver), data2, offset, len2);
    }

    public static void dumpHex(SimplifiedLog logger, Level level, String prefix2, char sep, int chunkSize, byte ... data2) {
        BufferUtils.dumpHex(logger, level, prefix2, sep, chunkSize, data2, 0, NumberUtils.length(data2));
    }

    public static void dumpHex(SimplifiedLog logger, Level level, String prefix2, char sep, int chunkSize, byte[] data2, int offset, int len2) {
        if (logger == null || level == null || !logger.isEnabledLevel(level)) {
            return;
        }
        StringBuilder sb = new StringBuilder(chunkSize * 3 + prefix2.length() + 64);
        sb.append(prefix2);
        int remainLen = len2;
        int chunkIndex = 1;
        int curOffset = offset;
        int totalLen = 0;
        while (remainLen > 0) {
            sb.setLength(prefix2.length());
            sb.append(" [chunk #").append(chunkIndex).append(']');
            int dumpSize = Math.min(chunkSize, remainLen);
            sb.append('(').append(totalLen += dumpSize).append('/').append(len2).append(')');
            try {
                BufferUtils.appendHex(sb.append(' '), data2, curOffset, dumpSize, sep);
            }
            catch (IOException e2) {
                sb.append(e2.getClass().getSimpleName()).append(": ").append(e2.getMessage());
            }
            for (int index = dumpSize; index < chunkSize; ++index) {
                if (sep != '\u0000') {
                    sb.append(' ');
                }
                sb.append("  ");
            }
            sb.append("    ");
            int pos = curOffset;
            for (int l = 0; l < dumpSize; ++l) {
                int b2 = data2[pos] & 0xFF;
                if (b2 > 32 && b2 < 126) {
                    sb.append((char)b2);
                } else {
                    sb.append('.');
                }
                ++pos;
            }
            logger.log(level, sb.toString());
            remainLen -= dumpSize;
            curOffset += dumpSize;
            ++chunkIndex;
        }
    }

    public static String toHex(byte ... array) {
        return BufferUtils.toHex(array, 0, NumberUtils.length(array));
    }

    public static String toHex(char sep, byte ... array) {
        return BufferUtils.toHex(array, 0, NumberUtils.length(array), sep);
    }

    public static String toHex(byte[] array, int offset, int len2) {
        return BufferUtils.toHex(array, offset, len2, ' ');
    }

    public static String toHex(byte[] array, int offset, int len2, char sep) {
        if (len2 <= 0) {
            return "";
        }
        try {
            return BufferUtils.appendHex(new StringBuilder(len2 * 3), array, offset, len2, sep).toString();
        }
        catch (IOException e2) {
            return e2.getClass().getSimpleName() + ": " + e2.getMessage();
        }
    }

    public static <A extends Appendable> A appendHex(A sb, char sep, byte ... array) throws IOException {
        return BufferUtils.appendHex(sb, array, 0, NumberUtils.length(array), sep);
    }

    public static <A extends Appendable> A appendHex(A sb, byte[] array, int offset, int len2, char sep) throws IOException {
        if (len2 <= 0) {
            return sb;
        }
        int maxOffset = offset + len2;
        for (int curOffset = offset; curOffset < maxOffset; ++curOffset) {
            byte b2 = array[curOffset];
            if (curOffset > offset && sep != '\u0000') {
                sb.append(sep);
            }
            sb.append(HEX_DIGITS.charAt(b2 >> 4 & 0xF));
            sb.append(HEX_DIGITS.charAt(b2 & 0xF));
        }
        return sb;
    }

    public static byte[] decodeHex(char separator, CharSequence csq) {
        return BufferUtils.decodeHex(separator, csq, 0, GenericUtils.length(csq));
    }

    public static byte[] decodeHex(char separator, CharSequence csq, int start2, int end2) {
        byte[] bytes;
        int len2 = end2 - start2;
        ValidateUtils.checkTrue(len2 >= 0, "Bad HEX sequence length: %d", len2);
        if (len2 == 0) {
            return GenericUtils.EMPTY_BYTE_ARRAY;
        }
        int delta = 2;
        if (separator != '\u0000') {
            ValidateUtils.checkTrue(len2 % 3 == 2, "Invalid separated HEX sequence length: %d", len2);
            bytes = new byte[(len2 + 1) / 3];
            ++delta;
        } else {
            ValidateUtils.checkTrue((len2 & 1) == 0, "Invalid contiguous HEX sequence length: %d", len2);
            bytes = new byte[len2 >>> 1];
        }
        int writeLen = 0;
        int curPos = start2;
        while (curPos < end2) {
            bytes[writeLen] = BufferUtils.fromHex(csq.charAt(curPos), csq.charAt(curPos + 1));
            curPos += delta;
            ++writeLen;
        }
        assert (writeLen == bytes.length);
        return bytes;
    }

    public static <S extends OutputStream> int decodeHex(S stream, char separator, CharSequence csq) throws IOException {
        return BufferUtils.decodeHex(stream, separator, csq, 0, GenericUtils.length(csq));
    }

    public static <S extends OutputStream> int decodeHex(S stream, char separator, CharSequence csq, int start2, int end2) throws IOException {
        int len2 = end2 - start2;
        ValidateUtils.checkTrue(len2 >= 0, "Bad HEX sequence length: %d", len2);
        int delta = 2;
        if (separator != '\u0000') {
            ValidateUtils.checkTrue(len2 % 3 == 2, "Invalid separated HEX sequence length: %d", len2);
            ++delta;
        } else {
            ValidateUtils.checkTrue((len2 & 1) == 0, "Invalid contiguous HEX sequence length: %d", len2);
        }
        int writeLen = 0;
        int curPos = start2;
        while (curPos < end2) {
            stream.write(BufferUtils.fromHex(csq.charAt(curPos), csq.charAt(curPos + 1)) & 0xFF);
            curPos += delta;
            ++writeLen;
        }
        return writeLen;
    }

    public static byte fromHex(char hi, char lo) throws NumberFormatException {
        int hiValue = HEX_DIGITS.indexOf(hi >= 65 && hi <= 70 ? 97 + (hi - 65) : hi);
        int loValue = HEX_DIGITS.indexOf(lo >= 65 && lo <= 70 ? 97 + (lo - 65) : lo);
        if (hiValue < 0 || loValue < 0) {
            throw new NumberFormatException("fromHex(" + new String(new char[]{hi, lo}) + ") non-HEX characters");
        }
        return (byte)((hiValue << 4) + loValue);
    }

    public static int readInt(InputStream input, byte[] buf) throws IOException {
        return BufferUtils.readInt(input, buf, 0, NumberUtils.length(buf));
    }

    public static int readInt(InputStream input, byte[] buf, int offset, int len2) throws IOException {
        return (int)BufferUtils.readUInt(input, buf, offset, len2);
    }

    public static long readUInt(InputStream input, byte[] buf) throws IOException {
        return BufferUtils.readUInt(input, buf, 0, NumberUtils.length(buf));
    }

    public static long readUInt(InputStream input, byte[] buf, int offset, int len2) throws IOException {
        try {
            if (len2 < 4) {
                throw new IllegalArgumentException("Not enough data for a UINT: required=4, available=" + len2);
            }
            IoUtils.readFully(input, buf, offset, 4);
            return BufferUtils.getUInt(buf, offset, len2);
        }
        catch (Error | RuntimeException e2) {
            throw new StreamCorruptedException("Failed (" + e2.getClass().getSimpleName() + ") to read UINT value: " + e2.getMessage());
        }
    }

    public static int getInt(byte[] buf, int off, int len2) {
        if (len2 < 4) {
            throw new IllegalArgumentException("Not enough data for an INT: required=4, available=" + len2);
        }
        int i2 = (buf[off++] & 0xFF) << 24;
        i2 |= (buf[off++] & 0xFF) << 16;
        i2 |= (buf[off++] & 0xFF) << 8;
        return i2 |= buf[off] & 0xFF;
    }

    public static long getUInt(byte ... buf) {
        return BufferUtils.getUInt(buf, 0, NumberUtils.length(buf));
    }

    public static long getUInt(byte[] buf, int off, int len2) {
        return (long)BufferUtils.getInt(buf, off, len2) & 0xFFFFFFFFL;
    }

    public static long getLong(byte[] buf, int off, int len2) {
        if (len2 < 8) {
            throw new IllegalArgumentException("Not enough data for a long: required=8, available=" + len2);
        }
        long l = (long)buf[off] << 56;
        l |= ((long)buf[off + 1] & 0xFFL) << 48;
        l |= ((long)buf[off + 2] & 0xFFL) << 40;
        l |= ((long)buf[off + 3] & 0xFFL) << 32;
        l |= ((long)buf[off + 4] & 0xFFL) << 24;
        l |= ((long)buf[off + 5] & 0xFFL) << 16;
        l |= ((long)buf[off + 6] & 0xFFL) << 8;
        return l |= (long)buf[off + 7] & 0xFFL;
    }

    public static BigInteger fromMPIntBytes(byte[] mpInt) {
        if (NumberUtils.isEmpty(mpInt)) {
            return null;
        }
        if ((mpInt[0] & 0x80) != 0) {
            return new BigInteger(1, mpInt);
        }
        return new BigInteger(mpInt);
    }

    public static void writeInt(OutputStream output, int value2, byte[] buf) throws IOException {
        BufferUtils.writeUInt(output, value2, buf, 0, NumberUtils.length(buf));
    }

    public static void writeInt(OutputStream output, int value2, byte[] buf, int off, int len2) throws IOException {
        BufferUtils.writeUInt(output, (long)value2 & 0xFFFFFFFFL, buf, off, len2);
    }

    public static void writeUInt(OutputStream output, long value2, byte[] buf) throws IOException {
        BufferUtils.writeUInt(output, value2, buf, 0, NumberUtils.length(buf));
    }

    public static void writeUInt(OutputStream output, long value2, byte[] buf, int off, int len2) throws IOException {
        try {
            int writeLen = BufferUtils.putUInt(value2, buf, off, len2);
            output.write(buf, off, writeLen);
        }
        catch (Error | RuntimeException e2) {
            throw new StreamCorruptedException("Failed (" + e2.getClass().getSimpleName() + ") to write UINT value=" + value2 + ": " + e2.getMessage());
        }
    }

    public static int putUInt(long value2, byte[] buf) {
        return BufferUtils.putUInt(value2, buf, 0, NumberUtils.length(buf));
    }

    public static int putUInt(long value2, byte[] buf, int off, int len2) {
        if (len2 < 4) {
            throw new IllegalArgumentException("Not enough data for a UINT: required=4, available=" + len2);
        }
        buf[off] = (byte)(value2 >> 24 & 0xFFL);
        buf[off + 1] = (byte)(value2 >> 16 & 0xFFL);
        buf[off + 2] = (byte)(value2 >> 8 & 0xFFL);
        buf[off + 3] = (byte)(value2 & 0xFFL);
        return 4;
    }

    public static int putLong(long value2, byte[] buf, int off, int len2) {
        if (len2 < 8) {
            throw new IllegalArgumentException("Not enough data for a long: required=8, available=" + len2);
        }
        buf[off] = (byte)(value2 >> 56);
        buf[off + 1] = (byte)(value2 >> 48);
        buf[off + 2] = (byte)(value2 >> 40);
        buf[off + 3] = (byte)(value2 >> 32);
        buf[off + 4] = (byte)(value2 >> 24);
        buf[off + 5] = (byte)(value2 >> 16);
        buf[off + 6] = (byte)(value2 >> 8);
        buf[off + 7] = (byte)value2;
        return 8;
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        int len2;
        int len1 = NumberUtils.length(a1);
        if (len1 != (len2 = NumberUtils.length(a2))) {
            return false;
        }
        return BufferUtils.equals(a1, 0, a2, 0, len1);
    }

    public static boolean equals(byte[] a1, int a1Offset, byte[] a2, int a2Offset, int length) {
        int len1 = NumberUtils.length(a1);
        int len2 = NumberUtils.length(a2);
        if (len1 < a1Offset + length || len2 < a2Offset + length) {
            return false;
        }
        while (length-- > 0) {
            if (a1[a1Offset++] == a2[a2Offset++]) continue;
            return false;
        }
        return true;
    }

    public static int getNextPowerOf2(int value2) {
        return value2 < 8 ? 8 : (value2 > 0x40000000 ? value2 : NumberUtils.getNextPowerOf2(value2));
    }

    public static int updateLengthPlaceholder(Buffer buffer, int lenPos) {
        int startPos = lenPos + 4;
        int endPos = buffer.wpos();
        int dataLength = endPos - startPos;
        ValidateUtils.checkTrue(dataLength >= 0, "Illegal data length: %d", dataLength);
        buffer.wpos(lenPos);
        buffer.putUInt(dataLength);
        buffer.wpos(endPos);
        return dataLength;
    }

    public static void updateLengthPlaceholder(Buffer buffer, int lenPos, long dataLength) {
        int curPos = buffer.wpos();
        buffer.wpos(lenPos);
        buffer.putUInt(dataLength);
        buffer.wpos(curPos);
    }

    public static <B extends Buffer> B clear(B buffer) {
        if (buffer != null) {
            buffer.clear();
        }
        return buffer;
    }

    public static long validateInt32Value(long value2, String message) {
        ValidateUtils.checkTrue(BufferUtils.isValidInt32Value(value2), message, value2);
        return value2;
    }

    public static long validateInt32Value(long value2, String format2, Object arg) {
        ValidateUtils.checkTrue(BufferUtils.isValidInt32Value(value2), format2, arg);
        return value2;
    }

    public static long validateInt32Value(long value2, String format2, Object ... args2) {
        ValidateUtils.checkTrue(BufferUtils.isValidInt32Value(value2), format2, args2);
        return value2;
    }

    public static boolean isValidInt32Value(long value2) {
        return value2 >= Integer.MIN_VALUE && value2 <= Integer.MAX_VALUE;
    }

    public static long validateUint32Value(long value2, String message) {
        ValidateUtils.checkTrue(BufferUtils.isValidUint32Value(value2), message, value2);
        return value2;
    }

    public static long validateUint32Value(long value2, String format2, Object arg) {
        ValidateUtils.checkTrue(BufferUtils.isValidUint32Value(value2), format2, arg);
        return value2;
    }

    public static long validateUint32Value(long value2, String format2, Object ... args2) {
        ValidateUtils.checkTrue(BufferUtils.isValidUint32Value(value2), format2, args2);
        return value2;
    }

    public static boolean isValidUint32Value(long value2) {
        return value2 >= 0L && value2 <= 0xFFFFFFFFL;
    }
}

