/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntUnaryOperator;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferException;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class ByteArrayBuffer
extends Buffer {
    public static final int DEFAULT_SIZE = 256;
    private byte[] data;
    private int rpos;
    private int wpos;

    public ByteArrayBuffer() {
        this(256, false);
    }

    public ByteArrayBuffer(int size2) {
        this(size2, true);
    }

    public ByteArrayBuffer(int size2, boolean roundOff) {
        this(new byte[roundOff ? BufferUtils.getNextPowerOf2(size2) : size2], false);
    }

    public ByteArrayBuffer(byte[] data2) {
        this(data2, 0, data2.length, true);
    }

    public ByteArrayBuffer(byte[] data2, boolean read2) {
        this(data2, 0, data2.length, read2);
    }

    public ByteArrayBuffer(byte[] data2, int off, int len2) {
        this(data2, off, len2, true);
    }

    public ByteArrayBuffer(byte[] data2, int off, int len2, boolean read2) {
        if (off < 0 || len2 < 0) {
            throw new IndexOutOfBoundsException("Invalid offset(" + off + ")/length(" + len2 + ")");
        }
        this.data = data2;
        this.rpos = off;
        this.wpos = (read2 ? len2 : 0) + off;
    }

    @Override
    public int rpos() {
        return this.rpos;
    }

    @Override
    public void rpos(int rpos) {
        this.rpos = rpos;
    }

    @Override
    public int wpos() {
        return this.wpos;
    }

    @Override
    public void wpos(int wpos) {
        if (wpos > this.wpos) {
            this.ensureCapacity(wpos - this.wpos);
        }
        this.wpos = wpos;
    }

    @Override
    public int available() {
        return this.wpos - this.rpos;
    }

    @Override
    public int capacity() {
        return this.data.length - this.wpos;
    }

    @Override
    public byte[] array() {
        return this.data;
    }

    @Override
    public byte[] getBytesConsumed() {
        byte[] consumed = new byte[this.rpos];
        System.arraycopy(this.data, 0, consumed, 0, this.rpos);
        return consumed;
    }

    @Override
    public byte[] getBytesConsumed(int from2) {
        if (from2 >= this.rpos) {
            return new byte[0];
        }
        return Arrays.copyOfRange(this.data, from2, this.rpos);
    }

    @Override
    public byte rawByte(int pos) {
        return this.data[pos];
    }

    @Override
    public long rawUInt(int pos) {
        return BufferUtils.getUInt(this.data, pos, 4);
    }

    @Override
    public void compact() {
        int avail = this.available();
        if (avail > 0) {
            System.arraycopy(this.data, this.rpos, this.data, 0, avail);
        }
        this.wpos -= this.rpos;
        this.rpos = 0;
    }

    @Override
    public Buffer clear(boolean wipeData) {
        this.rpos = 0;
        this.wpos = 0;
        if (wipeData) {
            Arrays.fill(this.data, (byte)0);
        }
        return this;
    }

    @Override
    public byte getByte() {
        if (this.rpos >= this.wpos) {
            throw new BufferException("Underflow: no available bytes in buffer");
        }
        return this.data[this.rpos++];
    }

    @Override
    public void putByte(byte b2) {
        if (this.wpos >= this.data.length) {
            this.ensureCapacity(1);
        }
        this.data[this.wpos++] = b2;
    }

    @Override
    public int getInt() {
        if (this.rpos + 4 > this.wpos) {
            throw new BufferException("Underflow: not enough bytes in buffer, need 4");
        }
        int i2 = BufferUtils.getInt(this.data, this.rpos, 4);
        this.rpos += 4;
        return i2;
    }

    @Override
    public void putInt(long i2) {
        ValidateUtils.checkTrue((long)((int)i2) == i2, "Invalid INT32 value: %d", i2);
        if (this.wpos + 4 > this.data.length) {
            this.ensureCapacity(4);
        }
        BufferUtils.putUInt(i2, this.data, this.wpos, 4);
        this.wpos += 4;
    }

    @Override
    public long getUInt() {
        if (this.rpos + 4 > this.wpos) {
            throw new BufferException("Underflow: not enough bytes in buffer, need 4");
        }
        long l = BufferUtils.getUInt(this.data, this.rpos, 4);
        this.rpos += 4;
        return l;
    }

    @Override
    public void putUInt(long i2) {
        ValidateUtils.checkTrue((i2 & 0xFFFFFFFFL) == i2, "Invalid UINT32 value: %d", i2);
        if (this.wpos + 4 > this.data.length) {
            this.ensureCapacity(4);
        }
        BufferUtils.putUInt(i2, this.data, this.wpos, 4);
        this.wpos += 4;
    }

    @Override
    public int putBuffer(Readable buffer, boolean expand) {
        int required = expand ? buffer.available() : Math.min(buffer.available(), this.capacity());
        this.ensureCapacity(required);
        buffer.getRawBytes(this.data, this.wpos, required);
        this.wpos += required;
        return required;
    }

    @Override
    public void putBuffer(ByteBuffer buffer) {
        int required = buffer.remaining();
        this.ensureCapacity(required + 4);
        this.putUInt(required);
        buffer.get(this.data, this.wpos, required);
        this.wpos += required;
    }

    @Override
    public void putBytes(byte[] b2, int off, int len2) {
        ValidateUtils.checkTrue(len2 >= 0, "Negative raw bytes length: %d", len2);
        if (this.wpos + 4 + len2 > this.data.length) {
            this.ensureCapacity(4 + len2);
        }
        BufferUtils.putUInt(len2, this.data, this.wpos, 4);
        this.wpos += 4;
        System.arraycopy(b2, off, this.data, this.wpos, len2);
        this.wpos += len2;
    }

    @Override
    public void putRawBytes(byte[] d2, int off, int len2) {
        ValidateUtils.checkTrue(len2 >= 0, "Negative raw bytes length: %d", len2);
        if (this.wpos + len2 > this.data.length) {
            this.ensureCapacity(len2);
        }
        System.arraycopy(d2, off, this.data, this.wpos, len2);
        this.wpos += len2;
    }

    @Override
    public String getString(Charset charset) {
        Objects.requireNonNull(charset, "No charset specified");
        int reqLen = this.getInt();
        int len2 = this.ensureAvailable(reqLen);
        String s2 = new String(this.data, this.rpos, len2, charset);
        this.rpos += len2;
        return s2;
    }

    @Override
    public void getRawBytes(byte[] buf, int off, int len2) {
        this.ensureAvailable(len2);
        this.copyRawBytes(0, buf, off, len2);
        this.rpos += len2;
    }

    @Override
    protected void copyRawBytes(int offset, byte[] buf, int pos, int len2) {
        if (offset < 0 || pos < 0 || len2 < 0) {
            throw new IndexOutOfBoundsException("Invalid offset(" + offset + ")/position(" + pos + ")/length(" + len2 + ") required");
        }
        System.arraycopy(this.data, this.rpos + offset, buf, pos, len2);
    }

    @Override
    public Buffer ensureCapacity(int capacity, IntUnaryOperator growthFactor) {
        ValidateUtils.checkTrue(capacity >= 0, "Negative capacity requested: %d", capacity);
        int maxSize2 = this.size();
        int curPos = this.wpos();
        int remaining = maxSize2 - curPos;
        if (remaining < capacity) {
            int minimum = curPos + capacity;
            int actual = growthFactor.applyAsInt(minimum);
            if (actual < minimum) {
                throw new IllegalStateException("ensureCapacity(" + capacity + ") actual (" + actual + ") below min. (" + minimum + ")");
            }
            byte[] tmp = new byte[actual];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
        return this;
    }

    @Override
    protected int size() {
        return this.data.length;
    }

    public static ByteArrayBuffer getCompactClone(byte[] data2) {
        return ByteArrayBuffer.getCompactClone(data2, 0, NumberUtils.length(data2));
    }

    public static ByteArrayBuffer getCompactClone(byte[] data2, int offset, int len2) {
        byte[] clone;
        byte[] byArray = clone = len2 > 0 ? new byte[len2] : GenericUtils.EMPTY_BYTE_ARRAY;
        if (len2 > 0) {
            System.arraycopy(data2, offset, clone, 0, len2);
        }
        return new ByteArrayBuffer(clone, true);
    }
}

