/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ProxyUtils;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCloseableDelegateInvocationHandler
implements InvocationHandler {
    private final Object proxyTarget;
    private final AutoCloseable delegate;
    private final Object[] closers;

    public AutoCloseableDelegateInvocationHandler(Object proxyTarget, AutoCloseable delegate) {
        this.proxyTarget = Objects.requireNonNull(proxyTarget, "No proxy target to wrap");
        this.delegate = Objects.requireNonNull(delegate, "No delegate to auto-close");
        this.closers = new Object[]{proxyTarget, delegate};
    }

    public Object getProxyTarget() {
        return this.proxyTarget;
    }

    public AutoCloseable getAutoCloseableDelegate() {
        return this.delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method2, Object[] args2) throws Throwable {
        if (!AutoCloseableDelegateInvocationHandler.isCloseMethodInvocation(method2, args2)) {
            Object target = this.getProxyTarget();
            try {
                return method2.invoke(target, args2);
            }
            catch (Throwable t2) {
                Class<?> targetType = target.getClass();
                Logger log2 = LoggerFactory.getLogger(targetType);
                LoggingUtils.debug(log2, "invoke({}#{}) failed ({}) to execute: {}", targetType.getSimpleName(), method2.getName(), t2.getClass().getSimpleName(), t2.getMessage(), t2);
                throw ProxyUtils.unwrapInvocationThrowable(t2);
            }
        }
        Throwable err = null;
        for (Object c2 : this.closers) {
            if (!(c2 instanceof AutoCloseable)) continue;
            try {
                method2.invoke(c2, args2);
            }
            catch (Throwable t3) {
                Class<?> closerType = c2.getClass();
                Logger log3 = LoggerFactory.getLogger(closerType);
                LoggingUtils.debug(log3, "invoke({}#{}) failed ({}) to execute: {}", closerType.getSimpleName(), method2.getName(), t3.getClass().getSimpleName(), t3.getMessage(), t3);
                err = ExceptionUtils.accumulateException(err, t3);
            }
        }
        if (err != null) {
            throw ProxyUtils.unwrapInvocationThrowable(err);
        }
        return null;
    }

    public static <T extends AutoCloseable> T wrapDelegateCloseable(Object proxyTarget, Class<T> type2, AutoCloseable delegate) {
        return (T)((AutoCloseable)ProxyUtils.newProxyInstance(type2, new AutoCloseableDelegateInvocationHandler(proxyTarget, delegate)));
    }

    public static boolean isCloseMethodInvocation(Method m4, Object[] args2) {
        return AutoCloseableDelegateInvocationHandler.isCloseMethod(m4) && GenericUtils.isEmpty(args2);
    }

    public static boolean isCloseMethod(Method m4) {
        int mods = m4 == null ? 0 : m4.getModifiers();
        return m4 != null && "close".equals(m4.getName()) && Modifier.isPublic(mods) && !Modifier.isStatic(mods) && Void.TYPE == m4.getReturnType() && GenericUtils.isEmpty(m4.getParameterTypes());
    }
}

