/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.closeable.SimpleCloseable;

public class FuturesCloseable<T extends SshFuture<T>>
extends SimpleCloseable {
    private final Iterable<? extends SshFuture<T>> futures;

    public FuturesCloseable(Object id, Object lock, Iterable<? extends SshFuture<T>> futures) {
        super(id, lock);
        this.futures = futures == null ? Collections.emptyList() : futures;
    }

    @Override
    protected void doClose(boolean immediately) {
        if (immediately) {
            for (SshFuture<T> f3 : this.futures) {
                if (!(f3 instanceof DefaultSshFuture)) continue;
                ((DefaultSshFuture)f3).setValue(new SshException("Closed"));
            }
            this.future.setClosed();
        } else {
            AtomicInteger count2 = new AtomicInteger(1);
            boolean traceEnabled = this.log.isTraceEnabled();
            SshFutureListener<SshFuture> listener = f2 -> {
                int pendingCount = count2.decrementAndGet();
                if (traceEnabled) {
                    this.log.trace("doClose({}) complete pending: {}", (Object)immediately, (Object)pendingCount);
                }
                if (pendingCount == 0) {
                    this.future.setClosed();
                }
            };
            for (SshFuture<SshFuture> sshFuture : this.futures) {
                if (sshFuture == null) continue;
                int pendingCount = count2.incrementAndGet();
                if (traceEnabled) {
                    this.log.trace("doClose({}) future pending: {}", (Object)immediately, (Object)pendingCount);
                }
                sshFuture.addListener(listener);
            }
            listener.operationComplete(null);
        }
    }
}

