/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.util.Collections;
import java.util.Iterator;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.closeable.SimpleCloseable;

public class SequentialCloseable
extends SimpleCloseable {
    private final Iterable<? extends Closeable> closeables;

    public SequentialCloseable(Object id, Object lock, Iterable<? extends Closeable> closeables) {
        super(id, lock);
        this.closeables = closeables == null ? Collections.emptyList() : closeables;
    }

    @Override
    protected void doClose(final boolean immediately) {
        final Iterator<? extends Closeable> iterator2 = this.closeables.iterator();
        SshFutureListener<CloseFuture> listener = new SshFutureListener<CloseFuture>(){

            @Override
            public void operationComplete(CloseFuture previousFuture) {
                boolean traceEnabled = SequentialCloseable.this.log.isTraceEnabled();
                while (iterator2.hasNext()) {
                    Closeable c2 = (Closeable)iterator2.next();
                    if (c2 == null) continue;
                    if (traceEnabled) {
                        SequentialCloseable.this.log.trace("doClose({}) closing {} immediately={}", this, c2, immediately);
                    }
                    CloseFuture nextFuture = c2.close(immediately);
                    nextFuture.addListener(this);
                    return;
                }
                if (!iterator2.hasNext()) {
                    if (SequentialCloseable.this.log.isDebugEnabled()) {
                        SequentialCloseable.this.log.debug("doClose({}) signal close complete immediately={}", (Object)this, (Object)immediately);
                    }
                    SequentialCloseable.this.future.setClosed();
                }
            }
        };
        listener.operationComplete(null);
    }
}

