/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.functors;

import java.util.function.IntUnaryOperator;
import org.apache.sshd.common.util.ValidateUtils;

public final class Int2IntFunction {
    private Int2IntFunction() {
        throw new UnsupportedOperationException("No instance");
    }

    public static IntUnaryOperator sub(int delta) {
        return Int2IntFunction.add(0 - delta);
    }

    public static IntUnaryOperator add(int delta) {
        if (delta == 0) {
            return IntUnaryOperator.identity();
        }
        return value2 -> value2 + delta;
    }

    public static IntUnaryOperator mul(int factor) {
        if (factor == 0) {
            return Int2IntFunction.constant(0);
        }
        if (factor == 1) {
            return IntUnaryOperator.identity();
        }
        return value2 -> value2 * factor;
    }

    public static IntUnaryOperator constant(int v) {
        return value2 -> v;
    }

    public static IntUnaryOperator div(int factor) {
        if (factor == 1) {
            return IntUnaryOperator.identity();
        }
        ValidateUtils.checkTrue(factor != 0, "Zero division factor");
        return value2 -> value2 / factor;
    }
}

