/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class PathScanningMatcher {
    protected boolean caseSensitive = OsUtils.isUNIX();
    protected String separator = File.separator;
    protected List<String> includePatterns;

    protected PathScanningMatcher() {
    }

    public void setIncludes(String ... includes) {
        this.setIncludes(GenericUtils.isEmpty(includes) ? Collections.emptyList() : Arrays.asList(includes));
    }

    public List<String> getIncludes() {
        return this.includePatterns;
    }

    public void setIncludes(Collection<String> includes) {
        this.includePatterns = GenericUtils.isEmpty(includes) ? Collections.emptyList() : Collections.unmodifiableList(includes.stream().map(PathScanningMatcher::normalizePattern).collect(Collectors.toCollection(() -> new ArrayList(includes.size()))));
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = ValidateUtils.checkNotNullAndNotEmpty(separator, "No separator provided");
    }

    protected boolean isIncluded(String name) {
        List<String> includes = this.getIncludes();
        if (GenericUtils.isEmpty(includes)) {
            return false;
        }
        boolean cs = this.isCaseSensitive();
        String sep = this.getSeparator();
        for (String include : includes) {
            if (!SelectorUtils.matchPath(include, name, sep, cs)) continue;
            return true;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String name) {
        List<String> includes = this.getIncludes();
        if (GenericUtils.isEmpty(includes)) {
            return false;
        }
        boolean cs = this.isCaseSensitive();
        String sep = this.getSeparator();
        for (String include : includes) {
            if (!SelectorUtils.matchPatternStart(include, name, sep, cs)) continue;
            return true;
        }
        return false;
    }

    public static String normalizePattern(String pattern2) {
        if ((pattern2 = pattern2.trim()).startsWith("%regex[")) {
            pattern2 = File.separatorChar == '\\' ? GenericUtils.replace(pattern2, "/", "\\\\", -1) : GenericUtils.replace(pattern2, "\\\\", "/", -1);
        } else if ((pattern2 = pattern2.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar)).endsWith(File.separator)) {
            pattern2 = pattern2 + "**";
        }
        return pattern2;
    }
}

