/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.der;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;

public enum ASN1Class {
    UNIVERSAL(0),
    APPLICATION(1),
    CONTEXT(2),
    PRIVATE(3);

    public static final List<ASN1Class> VALUES;
    private final byte byteValue;

    private ASN1Class(byte classValue) {
        this.byteValue = classValue;
    }

    public byte getClassValue() {
        return this.byteValue;
    }

    public static ASN1Class fromName(String s2) {
        if (GenericUtils.isEmpty(s2)) {
            return null;
        }
        for (ASN1Class c2 : VALUES) {
            if (!s2.equalsIgnoreCase(c2.name())) continue;
            return c2;
        }
        return null;
    }

    public static ASN1Class fromDERValue(int value2) {
        return ASN1Class.fromTypeValue(value2 >> 6 & 3);
    }

    public static ASN1Class fromTypeValue(int value2) {
        if (value2 < 0 || value2 >= VALUES.size()) {
            return null;
        }
        return VALUES.get(value2);
    }

    static {
        VALUES = Collections.unmodifiableList(Arrays.asList(ASN1Class.values()));
    }
}

