/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.der;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.io.der.ASN1Object;
import org.apache.sshd.common.util.io.der.ASN1Type;

public class DERParser
extends FilterInputStream {
    public static final int MAX_DER_VALUE_LENGTH = 65534;
    private final byte[] lenBytes = new byte[4];

    public DERParser(byte ... bytes) {
        this(bytes, 0, NumberUtils.length(bytes));
    }

    public DERParser(byte[] bytes, int offset, int len2) {
        this(new ByteArrayInputStream(bytes, offset, len2));
    }

    public DERParser(InputStream s2) {
        super(s2);
    }

    public int readLength() throws IOException {
        int i2 = this.read();
        if (i2 == -1) {
            throw new StreamCorruptedException("Invalid DER: length missing");
        }
        if ((i2 & 0xFFFFFF80) == 0) {
            return i2;
        }
        int num = i2 & 0x7F;
        if (i2 >= 255 || num > this.lenBytes.length) {
            throw new StreamCorruptedException("Invalid DER: length field too big: " + i2);
        }
        Arrays.fill(this.lenBytes, (byte)0);
        int n = this.read(this.lenBytes, 4 - num, num);
        if (n < num) {
            throw new StreamCorruptedException("Invalid DER: length data too short: expected=" + num + ", actual=" + n);
        }
        long len2 = BufferUtils.getUInt(this.lenBytes);
        if (len2 < 127L) {
            throw new StreamCorruptedException("Invalid DER: length not in shortest form: " + len2);
        }
        if (len2 > 65534L) {
            throw new StreamCorruptedException("Invalid DER: data length too big: " + len2 + " (max=" + 65534 + ")");
        }
        return (int)len2;
    }

    public ASN1Object readObject() throws IOException {
        int tag = this.read();
        if (tag == -1) {
            return null;
        }
        ASN1Type objType = ASN1Type.fromDERValue(tag);
        if (objType == ASN1Type.NULL) {
            return new ASN1Object((byte)tag, 0, GenericUtils.EMPTY_BYTE_ARRAY);
        }
        int length = this.readLength();
        byte[] value2 = new byte[length];
        int n = this.read(value2);
        if (n < length) {
            throw new StreamCorruptedException("Invalid DER: stream too short, missing value: read " + n + " out of required " + length);
        }
        return new ASN1Object((byte)tag, length, value2);
    }

    public BigInteger readBigInteger() throws IOException {
        int type2 = this.read();
        if (type2 != 2) {
            throw new StreamCorruptedException("Invalid DER: data type is not an INTEGER: 0x" + Integer.toHexString(type2));
        }
        int len2 = this.readLength();
        byte[] value2 = new byte[len2];
        int n = this.read(value2);
        if (n < len2) {
            throw new StreamCorruptedException("Invalid DER: stream too short, missing value: read " + n + " out of required " + len2);
        }
        return new BigInteger(value2);
    }
}

