/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.input;

import java.io.IOException;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.util.io.input.EmptyInputStream;

public class CloseableEmptyInputStream
extends EmptyInputStream
implements Channel {
    private final AtomicBoolean open = new AtomicBoolean(true);

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public int available() throws IOException {
        if (this.isOpen()) {
            return super.available();
        }
        throw new IOException("available() stream is closed");
    }

    @Override
    public int read() throws IOException {
        if (this.isOpen()) {
            return super.read();
        }
        throw new IOException("read() stream is closed");
    }

    @Override
    public int read(byte[] b2, int off, int len2) throws IOException {
        if (this.isOpen()) {
            return super.read(b2, off, len2);
        }
        throw new IOException("read([])[" + off + "," + len2 + "] stream is closed");
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.isOpen()) {
            return super.skip(n);
        }
        throw new IOException("skip(" + n + ") stream is closed");
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("reset() stream is closed");
        }
        super.reset();
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            return;
        }
    }
}

