/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.input;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicBoolean;

public class LimitInputStream
extends FilterInputStream
implements Channel {
    private final AtomicBoolean open = new AtomicBoolean(true);
    private long remaining;

    public LimitInputStream(InputStream in, long length) {
        super(in);
        this.remaining = length;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public int read() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("read() - stream is closed (remaining=" + this.remaining + ")");
        }
        if (this.remaining > 0L) {
            --this.remaining;
            return super.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b2, int off, int len2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("read(len=" + len2 + ") stream is closed (remaining=" + this.remaining + ")");
        }
        int nb = len2;
        if ((long)nb > this.remaining) {
            nb = (int)this.remaining;
        }
        if (nb > 0) {
            int read2 = super.read(b2, off, nb);
            this.remaining -= (long)read2;
            return read2;
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("skip(" + n + ") stream is closed (remaining=" + this.remaining + ")");
        }
        long skipped = super.skip(n);
        this.remaining -= skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("available() stream is closed (remaining=" + this.remaining + ")");
        }
        int av = super.available();
        if ((long)av > this.remaining) {
            return (int)this.remaining;
        }
        return av;
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            return;
        }
    }
}

