/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicBoolean;

public class NullInputStream
extends InputStream
implements Channel {
    private final AtomicBoolean open = new AtomicBoolean(true);

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public int read() throws IOException {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for reading one value");
        }
        return -1;
    }

    @Override
    public int read(byte[] b2, int off, int len2) throws IOException {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for reading " + len2 + " bytes");
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for skipping " + n + " bytes");
        }
        return 0L;
    }

    @Override
    public int available() throws IOException {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for availability query");
        }
        return 0;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for reset");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            return;
        }
    }
}

