/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.output;

import java.io.IOException;
import java.io.OutputStream;

public abstract class LineOutputStream
extends OutputStream {
    protected final byte[] oneByte = new byte[1];
    protected byte[] lineBuf;
    protected int usedLen;

    protected LineOutputStream() {
    }

    @Override
    public void write(int b2) throws IOException {
        this.oneByte[0] = (byte)(b2 & 0xFF);
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len2) throws IOException {
        int lastOffset = off;
        int maxOffset = off + len2;
        for (int curOffset = off; curOffset < maxOffset; ++curOffset) {
            byte ch = b2[curOffset];
            if (ch != 10) continue;
            if (this.usedLen > 0) {
                this.accumulateLineData(b2, lastOffset, curOffset - lastOffset);
                if (this.lineBuf[this.usedLen - 1] == 13) {
                    --this.usedLen;
                }
                this.handleLine(this.lineBuf, 0, this.usedLen);
                this.usedLen = 0;
            } else {
                int lineLen = curOffset - lastOffset;
                if (lineLen > 0 && b2[curOffset - 1] == 13) {
                    --lineLen;
                }
                this.handleLine(b2, lastOffset, lineLen);
            }
            lastOffset = curOffset + 1;
        }
        if (lastOffset < maxOffset) {
            this.accumulateLineData(b2, lastOffset, maxOffset - lastOffset);
        }
    }

    protected void accumulateLineData(byte[] b2, int off, int len2) throws IOException {
        if (len2 <= 0) {
            return;
        }
        int reqLen = this.usedLen + len2;
        if (this.lineBuf == null || reqLen >= this.lineBuf.length) {
            byte[] tmp = new byte[reqLen + 8];
            if (this.usedLen > 0) {
                System.arraycopy(this.lineBuf, 0, tmp, 0, this.usedLen);
            }
            this.lineBuf = tmp;
        }
        System.arraycopy(b2, off, this.lineBuf, this.usedLen, len2);
        this.usedLen += len2;
    }

    protected abstract void handleLine(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public void close() throws IOException {
        if (this.usedLen > 0) {
            if (this.lineBuf[this.usedLen - 1] == 13) {
                --this.usedLen;
            }
            this.handleLine(this.lineBuf, 0, this.usedLen);
            this.usedLen = 0;
        }
    }
}

