/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.output;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.CommonModuleProperties;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.slf4j.Logger;

public class LoggingFilterOutputStream
extends FilterOutputStream {
    private final String msg;
    private final SimplifiedLog log;
    private final int chunkSize;
    private final AtomicInteger writeCount = new AtomicInteger(0);

    public LoggingFilterOutputStream(OutputStream out2, String msg, Logger log2, PropertyResolver resolver) {
        this(out2, msg, log2, CommonModuleProperties.HEXDUMP_CHUNK_SIZE.getRequired(resolver));
    }

    public LoggingFilterOutputStream(OutputStream out2, String msg, Logger log2, int chunkSize) {
        super(out2);
        this.msg = msg;
        this.log = LoggingUtils.wrap(log2);
        this.chunkSize = chunkSize;
    }

    @Override
    public void write(int b2) throws IOException {
        byte[] d2 = new byte[]{(byte)b2};
        this.write(d2, 0, 1);
    }

    @Override
    public void write(byte[] b2, int off, int len2) throws IOException {
        int count2 = this.writeCount.incrementAndGet();
        BufferUtils.dumpHex(this.log, BufferUtils.DEFAULT_HEXDUMP_LEVEL, this.msg + "[" + count2 + "]", ' ', this.chunkSize, b2, off, len2);
        this.out.write(b2, off, len2);
    }
}

