/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.output;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public final class SecureByteArrayOutputStream
extends ByteArrayOutputStream {
    public SecureByteArrayOutputStream() {
    }

    public SecureByteArrayOutputStream(int initialSize) {
        super(initialSize);
    }

    @Override
    public void close() {
        Arrays.fill(this.buf, (byte)0);
    }

    @Override
    public void write(int b2) {
        byte[] oldBuf = this.buf;
        super.write(b2);
        if (this.buf != oldBuf) {
            Arrays.fill(oldBuf, (byte)0);
        }
    }

    @Override
    public void write(byte[] b2, int off, int len2) {
        byte[] oldBuf = this.buf;
        super.write(b2, off, len2);
        if (this.buf != oldBuf) {
            Arrays.fill(oldBuf, (byte)0);
        }
    }
}

