/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.resource;

import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.io.resource.ResourceStreamProvider;
import org.apache.sshd.common.util.io.resource.URIResource;
import org.apache.sshd.common.util.io.resource.URLResource;

public interface IoResource<T>
extends NamedResource,
ResourceStreamProvider {
    public Class<T> getResourceType();

    public T getResourceValue();

    public static IoResource<?> forResource(Object resource2) {
        if (resource2 == null) {
            return null;
        }
        if (resource2 instanceof Path) {
            return new PathResource((Path)resource2);
        }
        if (resource2 instanceof URL) {
            return new URLResource((URL)resource2);
        }
        if (resource2 instanceof URI) {
            return new URIResource((URI)resource2);
        }
        throw new UnsupportedOperationException("Unsupported resource type " + resource2.getClass().getSimpleName() + ": " + resource2);
    }
}

