/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.util.Objects;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityProviderChoice;

public interface SecurityEntityFactory<T> {
    public Class<T> getEntityType();

    public T getInstance(String var1) throws GeneralSecurityException;

    public static <F> SecurityEntityFactory<F> toFactory(Class<F> entityType, SecurityProviderChoice registrar, SecurityProviderChoice defaultProvider) throws ReflectiveOperationException {
        if (registrar == null) {
            if (defaultProvider == null || defaultProvider == SecurityProviderChoice.EMPTY) {
                return SecurityEntityFactory.toDefaultFactory(entityType);
            }
            if (defaultProvider.isNamedProviderUsed()) {
                return SecurityEntityFactory.toNamedProviderFactory(entityType, defaultProvider.getProviderName());
            }
            return SecurityEntityFactory.toProviderInstanceFactory(entityType, defaultProvider.getSecurityProvider());
        }
        if (registrar.isNamedProviderUsed()) {
            return SecurityEntityFactory.toNamedProviderFactory(entityType, registrar.getProviderName());
        }
        return SecurityEntityFactory.toProviderInstanceFactory(entityType, registrar.getSecurityProvider());
    }

    public static <F> SecurityEntityFactory<F> toDefaultFactory(final Class<F> entityType) throws ReflectiveOperationException {
        final Method m4 = entityType.getDeclaredMethod("getInstance", String.class);
        return new SecurityEntityFactory<F>(){
            private final String s;
            {
                this.s = SecurityEntityFactory.class.getSimpleName() + "[" + entityType.getSimpleName() + "][default]";
            }

            @Override
            public Class<F> getEntityType() {
                return entityType;
            }

            @Override
            public F getInstance(String algorithm) throws GeneralSecurityException {
                try {
                    Object value2 = m4.invoke(null, algorithm);
                    return entityType.cast(value2);
                }
                catch (ReflectiveOperationException t2) {
                    Throwable e2 = ExceptionUtils.peelException(t2);
                    if (e2 instanceof GeneralSecurityException) {
                        throw (GeneralSecurityException)e2;
                    }
                    if (e2 instanceof RuntimeException) {
                        throw (RuntimeException)e2;
                    }
                    if (e2 instanceof Error) {
                        throw (Error)e2;
                    }
                    throw new GeneralSecurityException(e2);
                }
            }

            public String toString() {
                return this.s;
            }
        };
    }

    public static <F> SecurityEntityFactory<F> toNamedProviderFactory(final Class<F> entityType, final String name) throws ReflectiveOperationException {
        ValidateUtils.checkNotNullAndNotEmpty(name, "No provider name specified");
        final Method m4 = entityType.getDeclaredMethod("getInstance", String.class, String.class);
        return new SecurityEntityFactory<F>(){
            private final String s;
            {
                this.s = SecurityEntityFactory.class.getSimpleName() + "[" + entityType.getSimpleName() + "][" + name + "]";
            }

            @Override
            public Class<F> getEntityType() {
                return entityType;
            }

            @Override
            public F getInstance(String algorithm) throws GeneralSecurityException {
                try {
                    Object value2 = m4.invoke(null, algorithm, name);
                    return entityType.cast(value2);
                }
                catch (ReflectiveOperationException t2) {
                    Throwable e2 = ExceptionUtils.peelException(t2);
                    if (e2 instanceof GeneralSecurityException) {
                        throw (GeneralSecurityException)e2;
                    }
                    if (e2 instanceof RuntimeException) {
                        throw (RuntimeException)e2;
                    }
                    if (e2 instanceof Error) {
                        throw (Error)e2;
                    }
                    throw new GeneralSecurityException(e2);
                }
            }

            public String toString() {
                return this.s;
            }
        };
    }

    public static <F> SecurityEntityFactory<F> toProviderInstanceFactory(final Class<F> entityType, final Provider provider2) throws ReflectiveOperationException {
        Objects.requireNonNull(provider2, "No provider instance");
        final Method m4 = entityType.getDeclaredMethod("getInstance", String.class, Provider.class);
        return new SecurityEntityFactory<F>(){
            private final String s;
            {
                this.s = SecurityEntityFactory.class.getSimpleName() + "[" + entityType.getSimpleName() + "][" + Provider.class.getSimpleName() + "][" + provider2.getName() + "]";
            }

            @Override
            public Class<F> getEntityType() {
                return entityType;
            }

            @Override
            public F getInstance(String algorithm) throws GeneralSecurityException {
                try {
                    Object value2 = m4.invoke(null, algorithm, provider2);
                    return entityType.cast(value2);
                }
                catch (ReflectiveOperationException t2) {
                    Throwable e2 = ExceptionUtils.peelException(t2);
                    if (e2 instanceof GeneralSecurityException) {
                        throw (GeneralSecurityException)e2;
                    }
                    if (e2 instanceof RuntimeException) {
                        throw (RuntimeException)e2;
                    }
                    if (e2 instanceof Error) {
                        throw (Error)e2;
                    }
                    throw new GeneralSecurityException(e2);
                }
            }

            public String toString() {
                return this.s;
            }
        };
    }
}

