/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.bouncycastle;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import org.apache.sshd.common.util.security.Decryptor;
import org.apache.sshd.common.util.security.SecurityProviderRegistrar;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;

public enum BouncyCastleEncryptedPrivateKeyInfoDecryptor implements Decryptor
{
    INSTANCE;


    @Override
    public byte[] decrypt(byte[] encrypted, char[] password) throws GeneralSecurityException {
        SecurityProviderRegistrar registrar = SecurityUtils.getRegisteredProvider("BC");
        if (registrar == null) {
            throw new NoSuchProviderException("BC registrar not available");
        }
        try {
            JcePKCSPBEInputDecryptorProviderBuilder builder = new JcePKCSPBEInputDecryptorProviderBuilder();
            if (registrar.isNamedProviderUsed()) {
                builder.setProvider(registrar.getProviderName());
            } else {
                builder.setProvider(registrar.getSecurityProvider());
            }
            PKCS8EncryptedPrivateKeyInfo info = new PKCS8EncryptedPrivateKeyInfo(encrypted);
            return info.decryptPrivateKeyInfo(builder.build(password)).getEncoded("DER");
        }
        catch (IOException | PKCSException e2) {
            throw new GeneralSecurityException(e2);
        }
    }
}

