/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.bouncycastle;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class BouncyCastleGeneratorHostKeyProvider
extends AbstractGeneratorHostKeyProvider {
    public BouncyCastleGeneratorHostKeyProvider(Path path2) {
        this.setPath(path2);
    }

    @Override
    protected void doWriteKeyPair(NamedResource resourceKey, KeyPair kp, OutputStream outputStream2) throws IOException, GeneralSecurityException {
        BouncyCastleGeneratorHostKeyProvider.writePEMKeyPair(kp, outputStream2);
    }

    public static void writePEMKeyPair(KeyPair kp, Path targetPath) throws IOException {
        BouncyCastleGeneratorHostKeyProvider.writePEMKeyPair(kp, targetPath, IoUtils.EMPTY_OPEN_OPTIONS);
    }

    public static void writePEMKeyPair(KeyPair kp, Path targetPath, OpenOption ... options2) throws IOException {
        try (OutputStream os = Files.newOutputStream(targetPath, options2);){
            BouncyCastleGeneratorHostKeyProvider.writePEMKeyPair(kp, os);
        }
    }

    public static void writePEMKeyPair(KeyPair kp, OutputStream outputStream2) throws IOException {
        try (JcaPEMWriter w = new JcaPEMWriter((Writer)new OutputStreamWriter(outputStream2, StandardCharsets.UTF_8));){
            w.writeObject((Object)kp);
            w.flush();
        }
    }
}

