/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.generic.EdDSASupport;
import org.apache.sshd.common.util.security.eddsa.generic.GenericEd25519PEMResourceKeyParser;

public class Ed25519PEMResourceKeyParser
extends GenericEd25519PEMResourceKeyParser {
    public static final Ed25519PEMResourceKeyParser INSTANCE = new Ed25519PEMResourceKeyParser();

    public static EdDSAPrivateKey decodeEdDSAPrivateKey(byte[] keyData) throws IOException, GeneralSecurityException {
        return (EdDSAPrivateKey)EdDSAPrivateKey.class.cast(EdDSASupport.decodeEdDSAPrivateKey(keyData));
    }

    public static EdDSAPrivateKey generateEdDSAPrivateKey(byte[] seed) throws GeneralSecurityException {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        EdDSANamedCurveSpec params = EdDSANamedCurveTable.getByName((String)"Ed25519");
        EdDSAPrivateKeySpec keySpec = new EdDSAPrivateKeySpec(seed, (EdDSAParameterSpec)params);
        KeyFactory factory2 = SecurityUtils.getKeyFactory("EdDSA");
        return (EdDSAPrivateKey)EdDSAPrivateKey.class.cast(factory2.generatePrivate((KeySpec)keySpec));
    }
}

