/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Signature;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.security.AbstractSecurityProviderRegistrar;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.NetI2pCryptoEdDSASupport;
import org.apache.sshd.common.util.security.eddsa.generic.EdDSASupport;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class EdDSASecurityProviderRegistrar
extends AbstractSecurityProviderRegistrar {
    public static final String PROVIDER_CLASS = "net.i2p.crypto.eddsa.EdDSASecurityProvider";
    private final AtomicReference<Boolean> supportHolder = new AtomicReference<Object>(null);

    public EdDSASecurityProviderRegistrar() {
        super("EdDSA");
    }

    @Override
    public boolean isEnabled() {
        if (SecurityUtils.isFipsMode() || !super.isEnabled()) {
            return false;
        }
        return this.getBooleanProperty("org.apache.sshd.eddsaSupport", true);
    }

    @Override
    public Provider getSecurityProvider() {
        try {
            return this.getOrCreateProvider(PROVIDER_CLASS);
        }
        catch (ReflectiveOperationException t2) {
            Throwable e2 = ExceptionUtils.peelException(t2);
            this.log.error("getSecurityProvider({}) failed ({}) to instantiate {}: {}", this.getName(), e2.getClass().getSimpleName(), PROVIDER_CLASS, e2.getMessage());
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public boolean isSecurityEntitySupported(Class<?> entityType, String name) {
        if (!this.isSupported()) {
            return false;
        }
        if (KeyPairGenerator.class.isAssignableFrom(entityType) || KeyFactory.class.isAssignableFrom(entityType)) {
            return Objects.compare(name, this.getName(), String.CASE_INSENSITIVE_ORDER) == 0;
        }
        if (Signature.class.isAssignableFrom(entityType)) {
            return Objects.compare("NONEwithEdDSA", name, String.CASE_INSENSITIVE_ORDER) == 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupported() {
        Boolean supported;
        AtomicReference<Boolean> atomicReference = this.supportHolder;
        synchronized (atomicReference) {
            supported = this.supportHolder.get();
            if (supported != null) {
                return supported;
            }
            Class<?> clazz = ThreadUtils.resolveDefaultClass(this.getClass(), "net.i2p.crypto.eddsa.EdDSAKey");
            supported = clazz != null;
            this.supportHolder.set(supported);
        }
        return supported;
    }

    @Override
    public Optional<EdDSASupport<?, ?>> getEdDSASupport() {
        if (!this.isSupported()) {
            return Optional.empty();
        }
        return Optional.of(new NetI2pCryptoEdDSASupport());
    }
}

