/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.apache.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.security.eddsa.Ed25519PEMResourceKeyParser;
import org.apache.sshd.common.util.security.eddsa.Ed25519PublicKeyDecoder;
import org.apache.sshd.common.util.security.eddsa.EdDSASecurityProviderUtils;
import org.apache.sshd.common.util.security.eddsa.OpenSSHEd25519PrivateKeyEntryDecoder;
import org.apache.sshd.common.util.security.eddsa.generic.EdDSASupport;

public class NetI2pCryptoEdDSASupport
implements EdDSASupport<EdDSAPublicKey, EdDSAPrivateKey> {
    @Override
    public PublicKeyEntryDecoder<EdDSAPublicKey, EdDSAPrivateKey> getEDDSAPublicKeyEntryDecoder() {
        return Ed25519PublicKeyDecoder.INSTANCE;
    }

    @Override
    public PrivateKeyEntryDecoder<EdDSAPublicKey, EdDSAPrivateKey> getOpenSSHEDDSAPrivateKeyEntryDecoder() {
        return OpenSSHEd25519PrivateKeyEntryDecoder.INSTANCE;
    }

    @Override
    public Signature getEDDSASigner() {
        return EdDSASecurityProviderUtils.getEDDSASignature();
    }

    @Override
    public int getEDDSAKeySize(Key key2) {
        return EdDSASecurityProviderUtils.getEDDSAKeySize(key2);
    }

    @Override
    public Class<? extends PublicKey> getEDDSAPublicKeyType() {
        return EdDSASecurityProviderUtils.getEDDSAPublicKeyType();
    }

    @Override
    public Class<? extends PrivateKey> getEDDSAPrivateKeyType() {
        return EdDSASecurityProviderUtils.getEDDSAPrivateKeyType();
    }

    @Override
    public boolean compareEDDSAPPublicKeys(PublicKey k1, PublicKey k2) {
        return EdDSASecurityProviderUtils.compareEDDSAPPublicKeys(k1, k2);
    }

    @Override
    public boolean compareEDDSAPrivateKeys(PrivateKey k1, PrivateKey k2) {
        return EdDSASecurityProviderUtils.compareEDDSAPrivateKeys(k1, k2);
    }

    @Override
    public EdDSAPublicKey recoverEDDSAPublicKey(PrivateKey key2) throws GeneralSecurityException {
        return EdDSASecurityProviderUtils.recoverEDDSAPublicKey(key2);
    }

    @Override
    public EdDSAPublicKey generateEDDSAPublicKey(byte[] seed) throws GeneralSecurityException {
        return (EdDSAPublicKey)EdDSASecurityProviderUtils.generateEDDSAPublicKey(seed);
    }

    @Override
    public EdDSAPrivateKey generateEDDSAPrivateKey(byte[] seed) throws GeneralSecurityException {
        return Ed25519PEMResourceKeyParser.generateEdDSAPrivateKey(seed);
    }

    @Override
    public <B extends Buffer> B putRawEDDSAPublicKey(B buffer, PublicKey key2) {
        return EdDSASecurityProviderUtils.putRawEDDSAPublicKey(buffer, key2);
    }

    @Override
    public <B extends Buffer> B putEDDSAKeyPair(B buffer, PublicKey pubKey, PrivateKey prvKey) {
        return EdDSASecurityProviderUtils.putEDDSAKeyPair(buffer, pubKey, prvKey);
    }

    @Override
    public KeySpec createPublicKeySpec(EdDSAPublicKey publicKey) {
        return new EdDSAPublicKeySpec(publicKey.getA(), publicKey.getParams());
    }

    @Override
    public KeySpec createPrivateKeySpec(EdDSAPrivateKey privateKey) {
        return new EdDSAPrivateKeySpec(privateKey.getSeed(), privateKey.getParams());
    }

    @Override
    public byte[] getPublicKeyData(EdDSAPublicKey publicKey) {
        return publicKey == null ? null : publicKey.getAbyte();
    }

    @Override
    public byte[] getPrivateKeyData(EdDSAPrivateKey privateKey) throws IOException {
        return privateKey.getSeed();
    }

    @Override
    public String getKeyFactoryAlgorithm() {
        return "EdDSA";
    }
}

