/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa.generic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.generic.EdDSASupport;

public class GenericEd25519PublicKeyDecoder<PUB extends PublicKey, PRV extends PrivateKey>
extends AbstractPublicKeyEntryDecoder<PUB, PRV> {
    public static final int MAX_ALLOWED_SEED_LEN = 1024;
    protected final EdDSASupport<PUB, PRV> edDSASupport;

    public GenericEd25519PublicKeyDecoder(Class<PUB> pubType, Class<PRV> prvType, EdDSASupport<PUB, PRV> edDSASupport) {
        super(pubType, prvType, Collections.singletonList("ssh-ed25519"));
        this.edDSASupport = edDSASupport;
    }

    @Override
    public PUB clonePublicKey(PUB key2) throws GeneralSecurityException {
        if (key2 == null) {
            return null;
        }
        return this.generatePublicKey(this.edDSASupport.createPublicKeySpec(key2));
    }

    @Override
    public PRV clonePrivateKey(PRV key2) throws GeneralSecurityException {
        if (key2 == null) {
            return null;
        }
        return this.generatePrivateKey(this.edDSASupport.createPrivateKeySpec(key2));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("EdDSA");
    }

    @Override
    public String encodePublicKey(OutputStream s2, PUB key2) throws IOException {
        Objects.requireNonNull(key2, "No public key provided");
        KeyEntryResolver.encodeString(s2, "ssh-ed25519");
        byte[] seed = this.edDSASupport.getPublicKeyData(key2);
        KeyEntryResolver.writeRLEBytes(s2, seed);
        return "ssh-ed25519";
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("EdDSA");
    }

    @Override
    public PUB decodePublicKey(SessionContext session2, String keyType, InputStream keyData, Map<String, String> headers2) throws IOException, GeneralSecurityException {
        byte[] seed = KeyEntryResolver.readRLEBytes(keyData, 1024);
        return this.edDSASupport.generateEDDSAPublicKey(seed);
    }
}

