/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.threads;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.Closeable;

public interface CloseableExecutorService
extends ExecutorService,
Closeable {
    default public boolean awaitTermination(Duration timeout2) throws InterruptedException {
        Objects.requireNonNull(timeout2, "No timeout specified");
        return this.awaitTermination(timeout2.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    default public void close() {
        try {
            Closeable.super.close();
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }
}

