/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.threads;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;

public class NoCloseExecutor
implements CloseableExecutorService {
    protected final ExecutorService executor;
    protected final CloseFuture closeFuture;

    public NoCloseExecutor(ExecutorService executor) {
        this.executor = executor;
        this.closeFuture = new DefaultCloseFuture(null, null);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result2) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.submit(task, result2);
    }

    @Override
    public Future<?> submit(Runnable task) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.invokeAll(tasks, timeout2, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.invokeAny(tasks, timeout2, unit);
    }

    @Override
    public void execute(Runnable command2) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        this.executor.execute(command2);
    }

    @Override
    public void shutdown() {
        this.close(true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.close(true);
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.isClosed();
    }

    @Override
    public boolean isTerminated() {
        return this.isClosed();
    }

    @Override
    public boolean awaitTermination(long timeout2, TimeUnit unit) throws InterruptedException {
        try {
            return this.closeFuture.await(timeout2, unit);
        }
        catch (IOException e2) {
            throw (InterruptedException)new InterruptedException().initCause(e2);
        }
    }

    @Override
    public CloseFuture close(boolean immediately) {
        this.closeFuture.setClosed();
        return this.closeFuture;
    }

    @Override
    public void addCloseFutureListener(SshFutureListener<CloseFuture> listener) {
        this.closeFuture.addListener(listener);
    }

    @Override
    public void removeCloseFutureListener(SshFutureListener<CloseFuture> listener) {
        this.closeFuture.removeListener(listener);
    }

    @Override
    public boolean isClosed() {
        return this.closeFuture.isClosed();
    }

    @Override
    public boolean isClosing() {
        return this.isClosed();
    }
}

