/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.gss;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.sshd.server.auth.gss.UserAuthGSS;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public final class CredentialHelper {
    private CredentialHelper() {
        throw new UnsupportedOperationException("No instance");
    }

    public static GSSCredential creds(GSSManager mgr, String spn, String keytab) throws LoginException, GSSException {
        LoginContext lc = new LoginContext("x", null, null, new FixedLoginConfiguration(spn, keytab));
        lc.login();
        try {
            return Subject.doAs(lc.getSubject(), new G(mgr));
        }
        catch (PrivilegedActionException e2) {
            throw (GSSException)e2.getCause();
        }
    }

    private static final class FixedLoginConfiguration
    extends Configuration {
        private AppConfigurationEntry entry;

        private FixedLoginConfiguration(String spn, String keytab) {
            TreeMap<String, String> params = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            params.put("isInitiator", "false");
            params.put("principal", spn);
            params.put("useKeyTab", "true");
            params.put("storeKey", "true");
            if (keytab != null) {
                params.put("keyTab", keytab);
            }
            this.entry = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, params);
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return new AppConfigurationEntry[]{this.entry};
        }

        @Override
        public void refresh() {
        }
    }

    private static final class G
    implements PrivilegedExceptionAction<GSSCredential> {
        private GSSManager mgr;

        private G(GSSManager mgr) {
            this.mgr = mgr;
        }

        @Override
        public GSSCredential run() throws GSSException {
            return this.mgr.createCredential(null, Integer.MAX_VALUE, UserAuthGSS.KRB5_MECH, 2);
        }
    }
}

