/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.gss;

import java.util.Objects;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class UserAuthGSS
extends AbstractUserAuth {
    public static final String NAME = "gssapi-with-mic";
    public static final Oid KRB5_MECH = UserAuthGSS.createOID("1.2.840.113554.1.2.2");
    public static final Oid KRB5_NT_PRINCIPAL = UserAuthGSS.createOID("1.2.840.113554.1.2.2.1");
    private GSSContext context;
    private String identity;

    public UserAuthGSS() {
        super(NAME);
    }

    @Override
    protected Boolean doAuth(Buffer buffer, boolean initial) throws Exception {
        ServerSession session2 = this.getServerSession();
        GSSAuthenticator auth = Objects.requireNonNull(session2.getGSSAuthenticator(), "No GSSAuthenticator configured");
        String user = this.getUsername();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (initial) {
            int num = buffer.getInt();
            if (num < 0 || num > 32768) {
                this.log.error("doAuth({}@{}) Illogical OID entries count: {}", user, session2, num);
                throw new IndexOutOfBoundsException("Illogical OID entries count: " + num);
            }
            boolean traceEnabled = this.log.isTraceEnabled();
            for (int i2 = 1; i2 <= num; ++i2) {
                Oid oid = new Oid(buffer.getBytes());
                if (!oid.equals(KRB5_MECH)) {
                    if (!traceEnabled) continue;
                    this.log.trace("doAuth({}@{}) skip OID {}/{}: {}", user, session2, i2, num, oid);
                    continue;
                }
                if (debugEnabled) {
                    this.log.debug("doAuth({}@{}) found Kerberos 5 after {}/{} OID(s)", user, session2, i2, num);
                }
                if (!auth.validateInitialUser(session2, user)) {
                    return Boolean.FALSE;
                }
                GSSManager mgr = auth.getGSSManager();
                GSSCredential creds = auth.getGSSCredential(mgr);
                if (creds == null) {
                    return Boolean.FALSE;
                }
                this.context = mgr.createContext(creds);
                byte[] out2 = oid.getDER();
                Buffer b2 = session2.createBuffer((byte)60, out2.length + 32);
                b2.putBytes(out2);
                session2.writePacket(b2);
                return null;
            }
            return Boolean.FALSE;
        }
        int msg = buffer.getUByte();
        if (!(msg == 61 || msg == 66 && this.context.isEstablished())) {
            throw new SshException(2, "Packet not supported by user authentication method: " + SshConstants.getCommandMessageName(msg));
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) In krb5.next: msg = {}", user, session2, SshConstants.getCommandMessageName(msg));
        }
        if (this.context.isEstablished()) {
            if (msg != 66) {
                return Boolean.FALSE;
            }
            ByteArrayBuffer msgbuf = new ByteArrayBuffer();
            msgbuf.putBytes(ValidateUtils.checkNotNullAndNotEmpty(session2.getSessionId(), "No current session ID"));
            ((Buffer)msgbuf).putByte((byte)50);
            msgbuf.putString(this.getUsername());
            msgbuf.putString(this.getService());
            msgbuf.putString(this.getName());
            byte[] msgbytes = msgbuf.getCompactData();
            byte[] inmic = buffer.getBytes();
            try {
                this.context.verifyMIC(inmic, 0, inmic.length, msgbytes, 0, msgbytes.length, new MessageProp(false));
                if (debugEnabled) {
                    this.log.debug("doAuth({}@{}) MIC verified", (Object)this.getUsername(), (Object)session2);
                }
                return Boolean.TRUE;
            }
            catch (GSSException e2) {
                if (debugEnabled) {
                    this.log.debug("doAuth({}@{}) GSS verification {} error: {}", user, session2, e2.getClass().getSimpleName(), e2.getMessage());
                }
                return Boolean.FALSE;
            }
        }
        byte[] tok = buffer.getBytes();
        byte[] out3 = this.context.acceptSecContext(tok, 0, tok.length);
        boolean established = this.context.isEstablished();
        if (established && this.identity == null) {
            GSSName srcName = this.context.getSrcName();
            this.identity = srcName.toString();
            if (debugEnabled) {
                this.log.debug("doAuth({}@{}) GSS identity is {}", user, session2, this.identity);
            }
            if (!auth.validateIdentity(session2, this.identity)) {
                return Boolean.FALSE;
            }
        }
        if (NumberUtils.length(out3) > 0) {
            Buffer b3 = session2.createBuffer((byte)61, out3.length + 32);
            b3.putBytes(out3);
            session2.writePacket(b3);
            return null;
        }
        return established;
    }

    @Override
    public void destroy() {
        if (this.context != null) {
            try {
                this.context.dispose();
            }
            catch (GSSException e2) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed ({}) to dispose of context: {}", (Object)e2.getClass().getSimpleName(), (Object)e2.getMessage());
                }
            }
            finally {
                this.context = null;
            }
        }
    }

    public static Oid createOID(String rep2) {
        try {
            return new Oid(rep2);
        }
        catch (GSSException e2) {
            return null;
        }
    }
}

