/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.keyboard;

import java.util.List;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.auth.keyboard.InteractiveChallenge;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class DefaultKeyboardInteractiveAuthenticator
extends AbstractLoggingBean
implements KeyboardInteractiveAuthenticator {
    public static final DefaultKeyboardInteractiveAuthenticator INSTANCE = new DefaultKeyboardInteractiveAuthenticator();

    @Override
    public InteractiveChallenge generateChallenge(ServerSession session2, String username, String lang, String subMethods) throws Exception {
        PasswordAuthenticator auth = session2.getPasswordAuthenticator();
        if (auth == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("generateChallenge({})[{}] no password authenticator", (Object)session2, (Object)username);
            }
            return null;
        }
        InteractiveChallenge challenge = new InteractiveChallenge();
        challenge.setInteractionName(this.getInteractionName(session2));
        challenge.setInteractionInstruction(this.getInteractionInstruction(session2));
        challenge.setLanguageTag(this.getInteractionLanguage(session2));
        challenge.addPrompt(this.getInteractionPrompt(session2), this.isInteractionPromptEchoEnabled(session2));
        return challenge;
    }

    @Override
    public boolean authenticate(ServerSession session2, String username, List<String> responses2) throws Exception {
        PasswordAuthenticator auth = session2.getPasswordAuthenticator();
        if (auth == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({})[{}] no password authenticator", (Object)session2, (Object)username);
            }
            return false;
        }
        int numResp = GenericUtils.size(responses2);
        if (numResp != 1) {
            throw new SshException("Mismatched number of responses");
        }
        try {
            return auth.authenticate(username, responses2.get(0), session2);
        }
        catch (Error e2) {
            this.warn("authenticate({})[{}] failed ({}) to consult password authenticator: {}", session2, username, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            throw new RuntimeSshException(e2);
        }
    }

    protected String getInteractionName(ServerSession session2) {
        return CoreModuleProperties.KB_SERVER_INTERACTIVE_NAME.getRequired(session2);
    }

    protected String getInteractionInstruction(ServerSession session2) {
        return CoreModuleProperties.KB_SERVER_INTERACTIVE_INSTRUCTION.getRequired(session2);
    }

    protected String getInteractionLanguage(ServerSession session2) {
        return CoreModuleProperties.KB_SERVER_INTERACTIVE_LANG.getRequired(session2);
    }

    protected String getInteractionPrompt(ServerSession session2) {
        return CoreModuleProperties.KB_SERVER_INTERACTIVE_PROMPT.getRequired(session2);
    }

    protected boolean isInteractionPromptEchoEnabled(ServerSession session2) {
        return CoreModuleProperties.KB_SERVER_INTERACTIVE_ECHO_PROMPT.getRequired(session2);
    }
}

