/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.keyboard;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.keyboard.InteractiveChallenge;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthKeyboardInteractive
extends AbstractUserAuth {
    public static final String NAME = "keyboard-interactive";

    public UserAuthKeyboardInteractive() {
        super(NAME);
    }

    @Override
    protected Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        ServerSession session2 = this.getServerSession();
        String username = this.getUsername();
        KeyboardInteractiveAuthenticator auth = session2.getKeyboardInteractiveAuthenticator();
        if (init) {
            return this.doInitialAuth(session2, username, auth, buffer);
        }
        return this.doValidateAuthResponse(session2, username, auth, buffer);
    }

    protected Boolean doInitialAuth(ServerSession session2, String username, KeyboardInteractiveAuthenticator auth, Buffer buffer) throws Exception {
        InteractiveChallenge challenge;
        String lang = buffer.getString();
        String subMethods = buffer.getString();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (auth == null) {
            if (debugEnabled) {
                this.log.debug("doAuth({}@{})[methods={}, lang={}] - no interactive authenticator to generate challenge", username, session2, subMethods, lang);
            }
            return false;
        }
        try {
            challenge = auth.generateChallenge(session2, username, lang, subMethods);
        }
        catch (Error e2) {
            this.warn("doAuth({}@{}) failed ({}) to generate authenticator challenge: {}", username, session2, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            throw new RuntimeSshException(e2);
        }
        if (challenge == null) {
            if (debugEnabled) {
                this.log.debug("doAuth({}@{})[methods={}, lang={}] - no interactive challenge generated", username, session2, subMethods, lang);
            }
            return false;
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{})[methods={}, lang={}] challenge name={}, instruction={}, lang={}, num. prompts={}", username, session2, subMethods, lang, challenge.getInteractionName(), challenge.getInteractionInstruction(), challenge.getLanguageTag(), GenericUtils.size(challenge.getPrompts()));
        }
        buffer = session2.createBuffer((byte)60);
        challenge.append(buffer);
        session2.writePacket(buffer);
        return null;
    }

    protected Boolean doValidateAuthResponse(ServerSession session2, String username, KeyboardInteractiveAuthenticator auth, Buffer buffer) throws Exception {
        boolean authed;
        int cmd = buffer.getUByte();
        if (cmd != 61) {
            throw new SshException("Received unexpected message: " + SshConstants.getCommandMessageName(cmd));
        }
        int num = buffer.getInt();
        if (num < 0 || num > 32768) {
            this.log.error("doValidateAuthResponse({}@{}) illogical response count: {}", username, session2, num);
            throw new IndexOutOfBoundsException("Illogical response count: " + num);
        }
        ArrayList<String> responses2 = num <= 0 ? Collections.emptyList() : new ArrayList<String>(num);
        for (int index = 1; index <= num; ++index) {
            String value2 = buffer.getString();
            responses2.add(value2);
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (auth == null) {
            if (debugEnabled) {
                this.log.debug("doAuth({}@{}) no interactive authenticator to validate {} responses", username, session2, num);
            }
            return false;
        }
        try {
            authed = auth.authenticate(session2, username, responses2);
        }
        catch (Error e2) {
            this.warn("doAuth({}@{}) failed ({}) to consult authenticator: {}", username, session2, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            throw new RuntimeSshException(e2);
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) authenticate {} responses result: {}", username, session2, num, authed);
        }
        return authed;
    }
}

