/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.password;

import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class StaticPasswordAuthenticator
extends AbstractLoggingBean
implements PasswordAuthenticator {
    private final boolean acceptance;

    public StaticPasswordAuthenticator(boolean acceptance) {
        this.acceptance = acceptance;
    }

    public final boolean isAccepted() {
        return this.acceptance;
    }

    @Override
    public final boolean authenticate(String username, String password, ServerSession session2) {
        boolean accepted = this.isAccepted();
        if (accepted) {
            this.handleAcceptance(username, password, session2);
        } else {
            this.handleRejection(username, password, session2);
        }
        return accepted;
    }

    protected void handleAcceptance(String username, String password, ServerSession session2) {
        this.log.warn("authenticate({}[{}]: accepted without checking", (Object)username, (Object)session2);
    }

    protected void handleRejection(String username, String password, ServerSession session2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({}[{}]: rejected", (Object)username, (Object)session2);
        }
    }
}

