/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.password;

import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.auth.UserAuthMethodFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.PasswordChangeRequiredException;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthPassword
extends AbstractUserAuth {
    public static final String NAME = "password";

    public UserAuthPassword() {
        super(NAME);
    }

    @Override
    public Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        ValidateUtils.checkTrue(init, "Instance not initialized");
        ServerSession session2 = this.getServerSession();
        if (!UserAuthMethodFactory.isSecureAuthenticationTransport(session2)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doAuth({}) session is not secure", (Object)session2);
            }
            return false;
        }
        String username = this.getUsername();
        boolean newPassword = buffer.getBoolean();
        String password = buffer.getString();
        if (newPassword) {
            return this.handleClientPasswordChangeRequest(buffer, session2, username, password, buffer.getString());
        }
        return this.checkPassword(buffer, session2, username, password);
    }

    protected Boolean checkPassword(Buffer buffer, ServerSession session2, String username, String password) throws Exception {
        boolean debugEnabled = this.log.isDebugEnabled();
        PasswordAuthenticator auth = session2.getPasswordAuthenticator();
        if (auth == null) {
            if (debugEnabled) {
                this.log.debug("checkPassword({}) no password authenticator", (Object)session2);
            }
            return false;
        }
        try {
            boolean authed;
            try {
                authed = auth.authenticate(username, password, session2);
            }
            catch (Error e2) {
                this.warn("checkPassword({}) failed ({}) to consult authenticator: {}", session2, e2.getClass().getSimpleName(), e2.getMessage(), e2);
                throw new RuntimeSshException(e2);
            }
            if (debugEnabled) {
                this.log.debug("checkPassword({}) authentication result: {}", (Object)session2, (Object)authed);
            }
            return authed;
        }
        catch (PasswordChangeRequiredException e3) {
            if (debugEnabled) {
                this.log.debug("checkPassword({}) password change required: {}", (Object)session2, (Object)e3.getMessage());
            }
            return this.handleServerPasswordChangeRequest(buffer, session2, username, password, e3);
        }
    }

    protected Boolean handleClientPasswordChangeRequest(Buffer buffer, ServerSession session2, String username, String oldPassword, String newPassword) throws Exception {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (!UserAuthMethodFactory.isDataIntegrityAuthenticationTransport(session2)) {
            if (debugEnabled) {
                this.log.debug("handleClientPasswordChangeRequest({}) session is not validated via MAC", (Object)session2);
            }
            return false;
        }
        PasswordAuthenticator auth = session2.getPasswordAuthenticator();
        if (auth == null) {
            if (debugEnabled) {
                this.log.debug("handleClientPasswordChangeRequest({}) no password authenticator", (Object)session2);
            }
            return false;
        }
        return auth.handleClientPasswordChangeRequest(session2, username, oldPassword, newPassword);
    }

    protected Boolean handleServerPasswordChangeRequest(Buffer buffer, ServerSession session2, String username, String password, PasswordChangeRequiredException e2) throws Exception {
        String prompt = e2.getPrompt();
        String lang = e2.getLanguage();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handlePasswordChangeRequest({}) password change required - prompt={}, lang={}", session2, prompt, lang);
        }
        buffer = session2.createBuffer((byte)60, GenericUtils.length(prompt) + GenericUtils.length(lang) + 32);
        buffer.putString(prompt);
        buffer.putString(lang);
        session2.writePacket(buffer);
        return null;
    }
}

