/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class AuthorizedKeyEntriesPublickeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    public static final AttributeRepository.AttributeKey<AuthorizedKeyEntry> AUTHORIZED_KEY = new AttributeRepository.AttributeKey();
    private Map<AuthorizedKeyEntry, PublicKey> resolvedKeys;
    private Object id;

    public AuthorizedKeyEntriesPublickeyAuthenticator(Object id, ServerSession session2, Collection<? extends AuthorizedKeyEntry> entries2, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        this.id = id;
        int numEntries = GenericUtils.size(entries2);
        if (numEntries <= 0) {
            this.resolvedKeys = Collections.emptyMap();
        } else {
            this.resolvedKeys = new HashMap<AuthorizedKeyEntry, PublicKey>(numEntries);
            for (AuthorizedKeyEntry authorizedKeyEntry : entries2) {
                Map<String, String> headers2;
                PublicKey k2 = authorizedKeyEntry.resolvePublicKey(session2, headers2 = authorizedKeyEntry.getLoginOptions(), fallbackResolver);
                if (k2 == null) continue;
                this.resolvedKeys.put(authorizedKeyEntry, k2);
            }
        }
    }

    public Object getId() {
        return this.id;
    }

    @Override
    public boolean authenticate(String username, PublicKey key2, ServerSession session2) {
        if (MapEntryUtils.isEmpty(this.resolvedKeys)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({})[{}] no entries", (Object)username, (Object)session2);
            }
            return false;
        }
        for (Map.Entry<AuthorizedKeyEntry, PublicKey> e2 : this.resolvedKeys.entrySet()) {
            if (!KeyUtils.compareKeys(key2, e2.getValue())) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({})[{}] match found", (Object)username, (Object)session2);
            }
            if (session2 != null) {
                session2.setAttribute(AUTHORIZED_KEY, e2.getKey());
            }
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({})[{}] match not found", (Object)username, (Object)session2);
        }
        return false;
    }

    public String toString() {
        return Objects.toString(this.getId());
    }
}

