/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.security.PublicKey;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class CachingPublicKeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    public static final AttributeRepository.AttributeKey<Map<PublicKey, Boolean>> CACHE_ATTRIBUTE = new AttributeRepository.AttributeKey();
    protected final PublickeyAuthenticator authenticator;

    public CachingPublicKeyAuthenticator(PublickeyAuthenticator authenticator) {
        this.authenticator = Objects.requireNonNull(authenticator, "No delegate authenticator");
    }

    @Override
    public boolean authenticate(String username, PublicKey key2, ServerSession session2) {
        Map<PublicKey, Boolean> map2 = this.resolveCachedResults(username, key2, session2);
        Boolean result2 = map2.get(key2);
        if (result2 == null) {
            try {
                result2 = this.authenticator.authenticate(username, key2, session2);
            }
            catch (Error e2) {
                this.warn("authenticate({}@{}) failed ({}) to consult delegate for {} key={}: {}", username, session2, e2.getClass().getSimpleName(), KeyUtils.getKeyType(key2), KeyUtils.getFingerPrint(key2), e2.getMessage(), e2);
                throw new RuntimeSshException(e2);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({}@{}) cache result={} for {} key={}", username, session2, result2, KeyUtils.getKeyType(key2), KeyUtils.getFingerPrint(key2));
            }
            map2.put(key2, result2);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({}@{}) use cached result={} for {} key={}", username, session2, result2, KeyUtils.getKeyType(key2), KeyUtils.getFingerPrint(key2));
        }
        return result2;
    }

    protected Map<PublicKey, Boolean> resolveCachedResults(String username, PublicKey key2, ServerSession session2) {
        return session2.computeAttributeIfAbsent(CACHE_ATTRIBUTE, attr -> new ConcurrentHashMap());
    }
}

