/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.security.PublicKey;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public abstract class StaticPublickeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    private final boolean acceptance;

    protected StaticPublickeyAuthenticator(boolean acceptance) {
        this.acceptance = acceptance;
    }

    public final boolean isAccepted() {
        return this.acceptance;
    }

    @Override
    public final boolean authenticate(String username, PublicKey key2, ServerSession session2) {
        boolean accepted = this.isAccepted();
        if (accepted) {
            this.handleAcceptance(username, key2, session2);
        }
        return accepted;
    }

    protected void handleAcceptance(String username, PublicKey key2, ServerSession session2) {
        this.log.warn("authenticate({}[{}][{}][{}]: accepted without checking", username, session2, key2 == null ? "null" : key2.getAlgorithm(), KeyUtils.getFingerPrint(key2));
    }

    protected void handleRejection(String username, PublicKey key2, ServerSession session2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({}[{}][{}][{}]: rejected", username, session2, key2 == null ? "null" : key2.getAlgorithm(), KeyUtils.getFingerPrint(key2));
        }
    }
}

