/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthPublicKey
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "publickey";
    private List<NamedFactory<Signature>> factories;

    public UserAuthPublicKey() {
        this((List<NamedFactory<Signature>>)null);
    }

    public UserAuthPublicKey(List<NamedFactory<Signature>> factories) {
        super(NAME);
        this.factories = factories;
    }

    @Override
    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    @Override
    public Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        boolean authed;
        ValidateUtils.checkTrue(init, "Instance not initialized");
        ServerSession session2 = this.getServerSession();
        String username = this.getUsername();
        boolean hasSig = buffer.getBoolean();
        String alg = buffer.getString();
        int oldLim = buffer.wpos();
        int oldPos = buffer.rpos();
        int len2 = buffer.getInt();
        int remaining = buffer.available();
        if (len2 < 0 || len2 > remaining) {
            this.log.error("doAuth({}@{}) illogical algorithm={} signature length ({}) when remaining={}", username, session2, alg, len2, remaining);
            throw new IndexOutOfBoundsException("Illogical signature length (" + len2 + ") for algorithm=" + alg);
        }
        buffer.wpos(buffer.rpos() + len2);
        PublicKey key2 = buffer.getRawPublicKey();
        if (key2 instanceof OpenSshCertificate) {
            OpenSshCertificate cert = (OpenSshCertificate)key2;
            try {
                if (!OpenSshCertificate.Type.USER.equals((Object)cert.getType())) {
                    throw new CertificateException("not a user certificate");
                }
                if (!OpenSshCertificate.isValidNow(cert)) {
                    throw new CertificateException("expired");
                }
                Collection<String> principals = cert.getPrincipals();
                if (!GenericUtils.isEmpty(principals) && !principals.contains(username)) {
                    throw new CertificateException("not valid for the given username");
                }
            }
            catch (CertificateException e2) {
                this.warn("doAuth({}@{}): public key certificate (id={}) is not valid: {}", username, session2, cert.getId(), e2.getMessage(), e2);
                throw e2;
            }
        }
        List<NamedFactory<Signature>> factories = ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(this, session2), "No signature factories for session=%s", session2);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) verify key type={}, factories={}, fingerprint={}", username, session2, alg, NamedResource.getNames(factories), KeyUtils.getFingerPrint(key2));
        }
        Signature verifier = ValidateUtils.checkNotNull(NamedFactory.create(factories, alg), "No verifier located for algorithm=%s", (Object)alg);
        verifier.initVerifier(session2, key2);
        buffer.wpos(oldLim);
        byte[] sig = hasSig ? buffer.getBytes() : null;
        PublickeyAuthenticator authenticator = session2.getPublickeyAuthenticator();
        if (authenticator == null) {
            if (debugEnabled) {
                this.log.debug("doAuth({}@{}) key type={}, fingerprint={} - no authenticator", username, session2, alg, KeyUtils.getFingerPrint(key2));
            }
            return Boolean.FALSE;
        }
        try {
            authed = authenticator.authenticate(username, key2, session2);
        }
        catch (Error e3) {
            this.warn("doAuth({}@{}) failed ({}) to consult delegate for {} key={}: {}", username, session2, e3.getClass().getSimpleName(), alg, KeyUtils.getFingerPrint(key2), e3.getMessage(), e3);
            throw new RuntimeSshException(e3);
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={} - authentication result: {}", username, session2, alg, KeyUtils.getFingerPrint(key2), authed);
        }
        if (!authed) {
            return Boolean.FALSE;
        }
        if (!hasSig) {
            this.sendPublicKeyResponse(session2, username, alg, key2, buffer.array(), oldPos, 4 + len2, buffer);
            return null;
        }
        buffer.rpos(oldPos);
        buffer.wpos(oldPos + 4 + len2);
        if (!this.verifySignature(session2, username, alg, key2, buffer, verifier, sig)) {
            throw new SignatureException("Key verification failed");
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={} - verified", username, session2, alg, KeyUtils.getFingerPrint(key2));
        }
        return Boolean.TRUE;
    }

    protected boolean verifySignature(ServerSession session2, String username, String alg, PublicKey key2, Buffer buffer, Signature verifier, byte[] sig) throws Exception {
        byte[] id = session2.getSessionId();
        String service = this.getService();
        String name = this.getName();
        ByteArrayBuffer buf = new ByteArrayBuffer(id.length + username.length() + service.length() + name.length() + alg.length() + 256 + 64, false);
        buf.putBytes(id);
        ((Buffer)buf).putByte((byte)50);
        buf.putString(username);
        buf.putString(service);
        buf.putString(name);
        buf.putBoolean(true);
        buf.putString(alg);
        buf.putBuffer(buffer);
        if (this.log.isTraceEnabled()) {
            this.log.trace("verifySignature({}@{})[{}][{}] key type={}, fingerprint={} - verification data={}", username, session2, service, name, alg, KeyUtils.getFingerPrint(key2), buf.toHex());
            this.log.trace("verifySignature({}@{})[{}][{}] key type={}, fingerprint={} - expected signature={}", username, session2, service, name, alg, KeyUtils.getFingerPrint(key2), BufferUtils.toHex(sig));
        }
        verifier.update(session2, ((Buffer)buf).array(), ((Buffer)buf).rpos(), buf.available());
        return verifier.verify(session2, sig);
    }

    protected void sendPublicKeyResponse(ServerSession session2, String username, String alg, PublicKey key2, byte[] keyBlob, int offset, int blobLen, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doAuth({}@{}) send SSH_MSG_USERAUTH_PK_OK for key type={}, fingerprint={}", username, session2, alg, KeyUtils.getFingerPrint(key2));
        }
        Buffer buf = session2.createBuffer((byte)60, GenericUtils.length(alg) + blobLen + 32);
        buf.putString(alg);
        buf.putRawBytes(keyBlob, offset, blobLen);
        session2.writePacket(buf);
    }
}

