/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.common.channel.ChannelPipedOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.util.io.output.LoggingFilterOutputStream;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.ChannelSession;

public class PipeDataReceiver
extends AbstractLoggingBean
implements ChannelDataReceiver {
    private InputStream in;
    private OutputStream out;

    public PipeDataReceiver(PropertyResolver resolver, LocalWindow localWindow) {
        ChannelPipedInputStream in = new ChannelPipedInputStream(resolver, localWindow);
        this.in = in;
        this.out = new ChannelPipedOutputStream(in);
        if (this.log.isTraceEnabled()) {
            this.out = new LoggingFilterOutputStream(this.out, "IN(" + resolver + "): ", this.log, resolver);
        }
    }

    public InputStream getIn() {
        return this.in;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public int data(ChannelSession channel2, byte[] buf, int start2, int len2) throws IOException {
        this.out.write(buf, start2, len2);
        return 0;
    }
}

