/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import java.io.IOException;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.command.CommandFactory;

public abstract class AbstractDelegatingCommandFactory
extends AbstractLoggingBean
implements CommandFactory {
    private final String name;
    private CommandFactory delegate;

    protected AbstractDelegatingCommandFactory(String name) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No delegating command factory name provided");
    }

    public String toString() {
        return this.name;
    }

    public CommandFactory getDelegateCommandFactory() {
        return this.delegate;
    }

    public void setDelegateCommandFactory(CommandFactory factory2) {
        this.delegate = factory2;
    }

    @Override
    public Command createCommand(ChannelSession channel2, String command2) throws IOException {
        if (this.isSupportedCommand(channel2, command2)) {
            return this.executeSupportedCommand(channel2, command2);
        }
        CommandFactory factory2 = this.getDelegateCommandFactory();
        if (factory2 != null) {
            return factory2.createCommand(channel2, command2);
        }
        return this.createUnsupportedCommand(channel2, command2);
    }

    public abstract boolean isSupportedCommand(ChannelSession var1, String var2);

    protected abstract Command executeSupportedCommand(ChannelSession var1, String var2);

    protected Command createUnsupportedCommand(ChannelSession channel2, String command2) {
        throw new IllegalArgumentException("Unknown command to execute: " + command2);
    }
}

