/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import java.io.IOException;
import java.nio.file.FileSystem;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.AbstractCommandSupport;

public abstract class AbstractFileSystemCommand
extends AbstractCommandSupport
implements FileSystemAware {
    protected FileSystem fileSystem;

    protected AbstractFileSystemCommand(String command2, CloseableExecutorService executorService) {
        super(command2, executorService);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void destroy(ChannelSession channel2) throws Exception {
        try {
            super.destroy(channel2);
            if (this.fileSystem == null) return;
        }
        catch (Throwable throwable) {
            if (this.fileSystem == null) throw throwable;
            try {
                this.fileSystem.close();
                throw throwable;
            }
            catch (IOException | UnsupportedOperationException e2) {
                if (!this.log.isDebugEnabled()) throw throwable;
                this.log.debug("destroy({}) - failed ({}) to close file system={}: {}", this, e2.getClass().getSimpleName(), this.fileSystem, e2.getMessage());
                throw throwable;
            }
            finally {
                this.fileSystem = null;
            }
        }
        try {
            this.fileSystem.close();
            return;
        }
        catch (IOException | UnsupportedOperationException e3) {
            if (!this.log.isDebugEnabled()) return;
            this.log.debug("destroy({}) - failed ({}) to close file system={}: {}", this, e3.getClass().getSimpleName(), this.fileSystem, e3.getMessage());
            return;
        }
        finally {
            this.fileSystem = null;
        }
    }
}

