/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;

@FunctionalInterface
public interface CommandFactory {
    public Command createCommand(ChannelSession var1, String var2) throws IOException;

    public static List<String> split(String command2) {
        int len2 = GenericUtils.length(command2);
        if (len2 <= 0) {
            return Collections.emptyList();
        }
        int curPos = command2.indexOf(32);
        if (curPos < 0) {
            return Collections.singletonList(command2);
        }
        int lastPos = 0;
        ArrayList<String> elements = new ArrayList<String>();
        for (curPos = 0; curPos < len2; ++curPos) {
            char ch = command2.charAt(curPos);
            if (!(ch != '\'' && ch != '\"' || curPos >= len2 - 1 || curPos != 0 && command2.charAt(curPos - 1) != ' ')) {
                int nextPos = command2.indexOf(ch, curPos + 1);
                if (nextPos <= curPos) continue;
                String elem = command2.substring(curPos + 1, nextPos);
                elements.add(elem);
                curPos = nextPos;
            } else {
                if (ch != ' ') continue;
                if (lastPos < curPos) {
                    String elem = command2.substring(lastPos, curPos);
                    elements.add(elem);
                }
            }
            ++curPos;
            while (curPos < len2 && (ch = command2.charAt(curPos)) == ' ') {
                ++curPos;
            }
            lastPos = curPos--;
        }
        if (lastPos < len2) {
            String elem = command2.substring(lastPos);
            elements.add(elem);
        }
        return elements;
    }
}

