/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.config;

import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.ConfigFileReaderSupport;
import org.apache.sshd.common.config.SshConfigFileReader;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.config.AllowTcpForwardingValue;
import org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import org.apache.sshd.server.forward.AgentForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.forward.TcpForwardingFilter;
import org.apache.sshd.server.forward.X11ForwardingFilter;

public final class SshServerConfigFileReader {
    public static final Property<String> ALLOW_TCP_FORWARDING_CONFIG_PROP = Property.string("AllowTcpForwarding", "yes");
    public static final Property<String> ALLOW_AGENT_FORWARDING_CONFIG_PROP = Property.string("AllowAgentForwarding", "yes");
    public static final Property<String> ALLOW_X11_FORWARDING_CONFIG_PROP = Property.string("X11Forwarding", "no");
    public static final Property<String> BANNER_CONFIG_PROP = Property.string("Banner");
    public static final Property<String> VISUAL_HOST_KEY = Property.string("VisualHostKey", "no");
    public static final Property<Duration> SERVER_ALIVE_INTERVAL_PROP = Property.duration("ServerAliveInterval");
    public static final Property<Integer> SFTP_FORCED_VERSION_PROP = Property.integer("sftp-version");

    private SshServerConfigFileReader() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static <S extends ServerFactoryManager> S setupServerHeartbeat(S server2, PropertyResolver props) {
        if (server2 == null || props == null) {
            return server2;
        }
        Duration interval = SERVER_ALIVE_INTERVAL_PROP.getOrNull(props);
        if (interval == null || GenericUtils.isNegativeOrNull(interval)) {
            return server2;
        }
        server2.setSessionHeartbeat(SessionHeartbeatController.HeartbeatType.IGNORE, interval);
        return server2;
    }

    public static <S extends ServerFactoryManager> S setupServerHeartbeat(S server2, Map<String, ?> options2) {
        if (server2 == null || MapEntryUtils.isEmpty(options2)) {
            return server2;
        }
        return SshServerConfigFileReader.setupServerHeartbeat(server2, PropertyResolverUtils.toPropertyResolver(options2));
    }

    public static <S extends ServerFactoryManager> S setupSftpSubsystem(S server2, PropertyResolver props) {
        if (server2 == null || props == null) {
            return server2;
        }
        Integer version2 = SFTP_FORCED_VERSION_PROP.getOrNull(props);
        if (version2 != null && version2 >= 0) {
            SFTP_FORCED_VERSION_PROP.set(server2, version2);
        }
        return server2;
    }

    public static <S extends SshServer> S configure(S server2, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        SshConfigFileReader.configure(server2, props, lenient, ignoreUnsupported);
        SshConfigFileReader.configureKeyExchanges(server2, props, lenient, ServerBuilder.DH2KEX, ignoreUnsupported);
        SshServerConfigFileReader.setupServerHeartbeat(server2, props);
        return server2;
    }

    public static ForwardingFilter resolveServerForwarding(PropertyResolver options2) {
        if (PropertyResolver.isEmpty(options2)) {
            return AcceptAllForwardingFilter.INSTANCE;
        }
        AgentForwardingFilter agentFilter = SshServerConfigFileReader.resolveAgentForwardingFilter(options2);
        TcpForwardingFilter tcpFilter = SshServerConfigFileReader.resolveTcpForwardingFilter(options2);
        X11ForwardingFilter x11Filter = SshServerConfigFileReader.resolveX11ForwardingFilter(options2);
        return ForwardingFilter.asForwardingFilter(agentFilter, x11Filter, tcpFilter);
    }

    public static AgentForwardingFilter resolveAgentForwardingFilter(PropertyResolver options2) {
        String value2 = ALLOW_AGENT_FORWARDING_CONFIG_PROP.getRequired(options2);
        return AgentForwardingFilter.of(ConfigFileReaderSupport.parseBooleanValue(value2));
    }

    public static TcpForwardingFilter resolveTcpForwardingFilter(PropertyResolver options2) {
        String value2 = ALLOW_TCP_FORWARDING_CONFIG_PROP.getRequired(options2);
        AllowTcpForwardingValue filter2 = AllowTcpForwardingValue.fromString(value2);
        ValidateUtils.checkNotNull(filter2, "Unknown %s value: %s", ALLOW_TCP_FORWARDING_CONFIG_PROP, value2);
        return filter2;
    }

    public static X11ForwardingFilter resolveX11ForwardingFilter(PropertyResolver options2) {
        String value2 = ALLOW_X11_FORWARDING_CONFIG_PROP.getRequired(options2);
        return X11ForwardingFilter.of(ConfigFileReaderSupport.parseBooleanValue(value2));
    }

    public static Object resolveBanner(PropertyResolver options2) {
        String bannerOption = BANNER_CONFIG_PROP.getOrNull(options2);
        if (GenericUtils.isEmpty(bannerOption)) {
            bannerOption = VISUAL_HOST_KEY.getRequired(options2);
            bannerOption = ConfigFileReaderSupport.parseBooleanValue(bannerOption) ? "#auto-welcome-banner" : null;
        }
        if (GenericUtils.isEmpty(bannerOption)) {
            return "Welcome to SSHD\n";
        }
        if (PropertyResolverUtils.isNoneValue(bannerOption)) {
            return null;
        }
        if ("#auto-welcome-banner".equalsIgnoreCase(bannerOption)) {
            return bannerOption;
        }
        if (bannerOption != null) {
            return Paths.get(bannerOption, new String[0]);
        }
        return null;
    }
}

