/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.config.keys;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.RejectAllPublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class AuthorizedKeysAuthenticator
extends ModifiableFileWatcher
implements PublickeyAuthenticator {
    public static final String STD_AUTHORIZED_KEYS_FILENAME = "authorized_keys";
    private final AtomicReference<PublickeyAuthenticator> delegateHolder = new AtomicReference<RejectAllPublickeyAuthenticator>(RejectAllPublickeyAuthenticator.INSTANCE);

    public AuthorizedKeysAuthenticator(Path file2) {
        this(file2, IoUtils.getLinkOptions(false));
    }

    public AuthorizedKeysAuthenticator(Path file2, LinkOption ... options2) {
        super(file2, options2);
    }

    @Override
    public boolean authenticate(String username, PublicKey key2, ServerSession session2) {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (!this.isValidUsername(username, session2)) {
            if (debugEnabled) {
                this.log.debug("authenticate({})[{}][{}] invalid user name - file = {}", username, session2, key2.getAlgorithm(), this.getPath());
            }
            return false;
        }
        try {
            PublickeyAuthenticator delegate = Objects.requireNonNull(this.resolvePublickeyAuthenticator(username, session2), "No delegate");
            boolean accepted = delegate.authenticate(username, key2, session2);
            if (debugEnabled) {
                this.log.debug("authenticate({})[{}][{}] invalid user name - accepted={} from file = {}", username, session2, key2.getAlgorithm(), accepted, this.getPath());
            }
            return accepted;
        }
        catch (Throwable e2) {
            this.debug("authenticate({})[{}] failed ({}) to authenticate {} key from {}: {}", username, session2, e2.getClass().getSimpleName(), key2.getAlgorithm(), this.getPath(), e2.getMessage(), e2);
            return false;
        }
    }

    protected boolean isValidUsername(String username, ServerSession session2) {
        return GenericUtils.isNotEmpty(username);
    }

    protected PublickeyAuthenticator resolvePublickeyAuthenticator(String username, ServerSession session2) throws IOException, GeneralSecurityException {
        if (this.checkReloadRequired()) {
            this.delegateHolder.set(RejectAllPublickeyAuthenticator.INSTANCE);
            Path path2 = this.getPath();
            if (this.exists()) {
                Collection<AuthorizedKeyEntry> entries2 = this.reloadAuthorizedKeys(path2, username, session2);
                if (GenericUtils.size(entries2) > 0) {
                    PublickeyAuthenticator authDelegate = this.createDelegateAuthenticator(username, session2, path2, entries2, this.getFallbackPublicKeyEntryResolver());
                    this.delegateHolder.set(authDelegate);
                }
            } else {
                this.log.info("resolvePublickeyAuthenticator({})[{}] no authorized keys file at {}", username, session2, path2);
            }
        }
        return this.delegateHolder.get();
    }

    protected PublickeyAuthenticator createDelegateAuthenticator(String username, ServerSession session2, Path path2, Collection<AuthorizedKeyEntry> entries2, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        return PublickeyAuthenticator.fromAuthorizedEntries(path2, session2, entries2, fallbackResolver);
    }

    protected PublicKeyEntryResolver getFallbackPublicKeyEntryResolver() {
        return PublicKeyEntryResolver.IGNORING;
    }

    protected Collection<AuthorizedKeyEntry> reloadAuthorizedKeys(Path path2, String username, ServerSession session2) throws IOException, GeneralSecurityException {
        List<AuthorizedKeyEntry> entries2 = AuthorizedKeyEntry.readAuthorizedKeys(path2, new OpenOption[0]);
        this.log.info("reloadAuthorizedKeys({})[{}] loaded {} keys from {}", username, session2, GenericUtils.size(entries2), path2);
        this.updateReloadAttributes();
        return entries2;
    }

    public static Path getDefaultAuthorizedKeysFile() {
        return LazyDefaultAuthorizedKeysFileHolder.KEYS_FILE;
    }

    public static List<AuthorizedKeyEntry> readDefaultAuthorizedKeys(OpenOption ... options2) throws IOException {
        Path keysFile = AuthorizedKeysAuthenticator.getDefaultAuthorizedKeysFile();
        if (Files.exists(keysFile, IoUtils.EMPTY_LINK_OPTIONS)) {
            return AuthorizedKeyEntry.readAuthorizedKeys(keysFile, new OpenOption[0]);
        }
        return Collections.emptyList();
    }

    private static final class LazyDefaultAuthorizedKeysFileHolder {
        private static final Path KEYS_FILE = PublicKeyEntry.getDefaultKeysFolderPath().resolve("authorized_keys");

        private LazyDefaultAuthorizedKeysFileHolder() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }
}

