/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.forward;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.channel.exception.SshChannelOpenException;
import org.apache.sshd.common.forward.ChannelToPortHandler;
import org.apache.sshd.common.forward.Forwarder;
import org.apache.sshd.common.forward.ForwardingTunnelEndpointsProvider;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.forward.TcpForwardingFilter;

public class TcpipServerChannel
extends AbstractServerChannel
implements ForwardingTunnelEndpointsProvider {
    private final TcpForwardingFilter.Type type;
    private IoConnector connector;
    private ChannelToPortHandler port;
    private ChannelAsyncOutputStream out;
    private SshdSocketAddress tunnelEntrance;
    private SshdSocketAddress tunnelExit;
    private SshdSocketAddress originatorAddress;
    private SocketAddress localAddress;

    public TcpipServerChannel(TcpForwardingFilter.Type type2, CloseableExecutorService executor) {
        super("", Collections.emptyList(), executor);
        this.type = Objects.requireNonNull(type2, "No channel type specified");
    }

    public TcpForwardingFilter.Type getTcpipChannelType() {
        return this.type;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(SocketAddress localAddress2) {
        this.localAddress = localAddress2;
    }

    @Override
    public SshdSocketAddress getTunnelEntrance() {
        return this.tunnelEntrance;
    }

    @Override
    public SshdSocketAddress getTunnelExit() {
        return this.tunnelExit;
    }

    public SshdSocketAddress getOriginatorAddress() {
        return this.originatorAddress;
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) throws IOException {
        super.handleWindowAdjust(buffer);
        if (this.out != null) {
            this.out.onWindowExpanded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f2;
        FactoryManager manager;
        SshdSocketAddress address;
        block11: {
            String hostToConnect = buffer.getString();
            int portToConnect = buffer.getInt();
            String originatorIpAddress = buffer.getString();
            int originatorPort = buffer.getInt();
            boolean debugEnabled = this.log.isDebugEnabled();
            if (debugEnabled) {
                this.log.debug("doInit({}) Receiving request for direct tcpip: hostToConnect={}, portToConnect={}, originatorIpAddress={}, originatorPort={}", this, hostToConnect, portToConnect, originatorIpAddress, originatorPort);
            }
            TcpForwardingFilter.Type channelType = this.getTcpipChannelType();
            switch (this.type) {
                case Direct: {
                    address = new SshdSocketAddress(hostToConnect, portToConnect);
                    break;
                }
                case Forwarded: {
                    Forwarder forwarder = this.service.getForwarder();
                    address = forwarder.getForwardedPort(portToConnect);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown server channel type: " + channelType);
                }
            }
            this.originatorAddress = new SshdSocketAddress(originatorIpAddress, originatorPort);
            this.tunnelEntrance = new SshdSocketAddress(hostToConnect, portToConnect);
            this.tunnelExit = address;
            Session session2 = this.getSession();
            manager = Objects.requireNonNull(session2.getFactoryManager(), "No factory manager");
            TcpForwardingFilter filter2 = manager.getTcpForwardingFilter();
            f2 = new DefaultOpenFuture(this, this);
            try {
                if (address != null && filter2 != null && filter2.canConnect(channelType, address, session2)) break block11;
                if (debugEnabled) {
                    this.log.debug("doInit({})[{}][haveFilter={}] filtered out {}", this, this.type, filter2 != null, address);
                }
                try {
                    f2.setException(new SshChannelOpenException(this.getChannelId(), 1, "Connection denied"));
                }
                finally {
                    super.close(true);
                }
                return f2;
            }
            catch (Error e2) {
                this.warn("doInit({})[{}] failed ({}) to consult forwarding filter: {}", session2, channelType, e2.getClass().getSimpleName(), e2.getMessage(), e2);
                throw new RuntimeSshException(e2);
            }
        }
        this.out = new ChannelAsyncOutputStream(this, 94){

            @Override
            protected CloseFuture doCloseGracefully() {
                DefaultCloseFuture result2 = new DefaultCloseFuture(TcpipServerChannel.this.getChannelId(), this.futureLock);
                CloseFuture packetsWritten = super.doCloseGracefully();
                packetsWritten.addListener(p -> {
                    try {
                        IoWriteFuture eofSent = TcpipServerChannel.this.sendEof();
                        if (eofSent != null) {
                            eofSent.addListener(f2 -> result2.setClosed());
                            return;
                        }
                    }
                    catch (Exception e2) {
                        TcpipServerChannel.this.getSession().exceptionCaught(e2);
                    }
                    result2.setClosed();
                });
                return result2;
            }
        };
        IoServiceFactory ioServiceFactory = manager.getIoServiceFactory();
        this.connector = ioServiceFactory.createConnector(new PortIoHandler());
        IoConnectFuture future = this.connector.connect(address.toInetSocketAddress(), null, this.getLocalAddress());
        future.addListener(future1 -> this.handleChannelConnectResult(f2, (IoConnectFuture)future1));
        return f2;
    }

    @Override
    protected boolean mayWrite() {
        return !this.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChannelConnectResult(OpenFuture f2, IoConnectFuture future) {
        try {
            if (future.isConnected()) {
                this.handleChannelOpenSuccess(f2, future.getSession());
                return;
            }
            Throwable problem = ExceptionUtils.peelException(future.getException());
            if (problem != null) {
                this.handleChannelOpenFailure(f2, problem);
            }
        }
        catch (RuntimeException t2) {
            Throwable e2 = ExceptionUtils.peelException(t2);
            this.signalChannelOpenFailure(e2);
            try {
                f2.setException(e2);
            }
            finally {
                this.notifyStateChanged(e2.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChannelOpenSuccess(OpenFuture f2, IoSession session2) {
        this.port = this.createChannelToPortHandler(session2);
        String changeEvent = session2.toString();
        try {
            this.signalChannelOpenSuccess();
            f2.setOpened();
            if (f2.isCanceled()) {
                this.close(false).addListener(cf -> f2.getCancellation().setCanceled());
            } else {
                session2.resumeRead();
            }
        }
        catch (Throwable t2) {
            Throwable e2 = ExceptionUtils.peelException(t2);
            changeEvent = e2.getClass().getSimpleName();
            this.signalChannelOpenFailure(e2);
            f2.setException(e2);
        }
        finally {
            this.notifyStateChanged(changeEvent);
        }
    }

    protected void handleChannelOpenFailure(OpenFuture f2, Throwable problem) {
        this.signalChannelOpenFailure(problem);
        this.notifyStateChanged(problem.getClass().getSimpleName());
        try {
            if (problem instanceof ConnectException) {
                f2.setException(new SshChannelOpenException(this.getChannelId(), 2, problem.getMessage(), problem));
            } else {
                f2.setException(problem);
            }
        }
        finally {
            this.close(true);
        }
    }

    @Override
    public void handleEof() throws IOException {
        super.handleEof();
        if (this.port != null) {
            this.port.handleEof();
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(this.out).close(super.getInnerCloseable()).close(new AbstractCloseable(){
            private final CloseableExecutorService executor;
            {
                this.executor = ThreadUtils.newCachedThreadPool("TcpIpServerChannel-ConnectorCleanup[" + TcpipServerChannel.this.getSession() + "]");
            }

            @Override
            protected CloseFuture doCloseGracefully() {
                this.executor.submit(() -> TcpipServerChannel.this.connector.close(false));
                return null;
            }

            @Override
            protected void doCloseImmediately() {
                this.executor.submit(() -> TcpipServerChannel.this.connector.close(true).addListener(f2 -> this.executor.close(true)));
                super.doCloseImmediately();
            }
        }).build();
    }

    @Override
    protected void doWriteData(byte[] data2, int off, long len2) throws IOException {
        this.port.sendToPort((byte)94, data2, off, len2);
    }

    @Override
    protected void doWriteExtendedData(byte[] data2, int off, long len2) throws IOException {
        throw new UnsupportedOperationException(this.getTcpipChannelType() + " Tcpip channel does not support extended data");
    }

    protected ChannelToPortHandler createChannelToPortHandler(IoSession session2) {
        return new ChannelToPortHandler(session2, this);
    }

    class PortIoHandler
    implements IoHandler {
        PortIoHandler() {
        }

        @Override
        public void messageReceived(IoSession session2, Readable message) throws Exception {
            if (TcpipServerChannel.this.isClosing()) {
                if (TcpipServerChannel.this.log.isDebugEnabled()) {
                    TcpipServerChannel.this.log.debug("messageReceived({}) Ignoring write to channel {} in CLOSING state", (Object)session2, (Object)TcpipServerChannel.this);
                }
            } else {
                int length = message.available();
                ByteArrayBuffer buffer = new ByteArrayBuffer(length, false);
                buffer.putBuffer(message);
                session2.suspendRead();
                ThreadUtils.runAsInternal(() -> TcpipServerChannel.this.out.writeBuffer(buffer).addListener(f2 -> {
                    session2.resumeRead();
                    Throwable e2 = f2.getException();
                    if (e2 != null) {
                        TcpipServerChannel.this.log.warn("messageReceived({}) channel={} signal close immediately=true due to {}[{}]", session2, TcpipServerChannel.this, e2.getClass().getSimpleName(), e2.getMessage());
                        TcpipServerChannel.this.close(true);
                    } else if (TcpipServerChannel.this.log.isTraceEnabled()) {
                        TcpipServerChannel.this.log.trace("messageReceived({}) channel={} message forwarded", (Object)session2, (Object)TcpipServerChannel.this);
                    }
                }));
            }
        }

        @Override
        public void sessionCreated(IoSession session2) throws Exception {
            session2.suspendRead();
        }

        @Override
        public void sessionClosed(IoSession session2) throws Exception {
            TcpipServerChannel.this.close(false);
        }

        @Override
        public void exceptionCaught(IoSession session2, Throwable cause) throws Exception {
            boolean immediately;
            boolean bl = immediately = !session2.isOpen();
            if (TcpipServerChannel.this.log.isDebugEnabled()) {
                TcpipServerChannel.this.log.debug("exceptionCaught({}) signal close immediately={}", TcpipServerChannel.this, immediately, cause);
            }
            TcpipServerChannel.this.close(immediately);
        }
    }

    public static abstract class TcpipFactory
    implements ChannelFactory,
    ExecutorServiceCarrier {
        private final TcpForwardingFilter.Type type;

        protected TcpipFactory(TcpForwardingFilter.Type type2) {
            this.type = type2;
        }

        public final TcpForwardingFilter.Type getType() {
            return this.type;
        }

        @Override
        public final String getName() {
            return this.type.getName();
        }

        @Override
        public CloseableExecutorService getExecutorService() {
            return null;
        }

        @Override
        public Channel createChannel(Session session2) throws IOException {
            return new TcpipServerChannel(this.getType(), ThreadUtils.noClose(this.getExecutorService()));
        }
    }
}

