/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.global;

import java.util.Objects;
import java.util.function.IntUnaryOperator;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.forward.Forwarder;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.helpers.AbstractConnectionServiceRequestHandler;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.functors.Int2IntFunction;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class TcpipForwardHandler
extends AbstractConnectionServiceRequestHandler {
    public static final String REQUEST = "tcpip-forward";
    public static final IntUnaryOperator RESPONSE_BUFFER_GROWTH_FACTOR = Int2IntFunction.add(8);
    public static final TcpipForwardHandler INSTANCE = new TcpipForwardHandler();

    @Override
    public RequestHandler.Result process(ConnectionService connectionService, String request2, boolean wantReply, Buffer buffer) throws Exception {
        if (!REQUEST.equals(request2)) {
            return super.process(connectionService, request2, wantReply, buffer);
        }
        String address = buffer.getString();
        int port2 = buffer.getInt();
        SshdSocketAddress socketAddress = new SshdSocketAddress(address, port2);
        Forwarder forwarder = Objects.requireNonNull(connectionService.getForwarder(), "No TCP/IP forwarder");
        SshdSocketAddress bound = forwarder.localPortForwardingRequested(socketAddress);
        if (this.log.isDebugEnabled()) {
            this.log.debug("process({})[{}][want-reply-{}] {} => {}", connectionService, request2, wantReply, socketAddress, bound);
        }
        if (bound == null) {
            return RequestHandler.Result.ReplyFailure;
        }
        port2 = bound.getPort();
        if (wantReply) {
            Object session2 = connectionService.getSession();
            buffer = session2.createBuffer((byte)81, 4);
            buffer.putUInt(port2);
            session2.writePacket(buffer);
        }
        return RequestHandler.Result.Replied;
    }
}

