/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.jaas;

import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class JaasPasswordAuthenticator
extends AbstractLoggingBean
implements PasswordAuthenticator {
    private String domain;

    public JaasPasswordAuthenticator() {
        this((String)null);
    }

    public JaasPasswordAuthenticator(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public boolean authenticate(String username, String password, ServerSession session2) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.getDomain(), subject, callbacks -> {
                for (Callback callback2 : callbacks) {
                    if (callback2 instanceof NameCallback) {
                        ((NameCallback)callback2).setName(username);
                        continue;
                    }
                    if (callback2 instanceof PasswordCallback) {
                        ((PasswordCallback)callback2).setPassword(password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback2);
                }
            });
            loginContext.login();
            loginContext.logout();
            return true;
        }
        catch (Exception e2) {
            this.warn("authenticate({}) failed ({}) to authenticate user={}: {}", session2, e2.getClass().getSimpleName(), username, e2.getMessage(), e2);
            return false;
        }
    }
}

