/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.keyprovider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.AlgorithmNameProvider;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeySizeIndicator;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class AbstractGeneratorHostKeyProvider
extends AbstractKeyPairProvider
implements AlgorithmNameProvider,
KeySizeIndicator {
    public static final String DEFAULT_ALGORITHM = "EC";
    public static final boolean DEFAULT_ALLOWED_TO_OVERWRITE = true;
    private final AtomicReference<Iterable<KeyPair>> keyPairHolder = new AtomicReference();
    private Path path;
    private String algorithm = "EC";
    private int keySize;
    private AlgorithmParameterSpec keySpec;
    private boolean overwriteAllowed = true;
    private boolean enforceFilePermissions = true;

    protected AbstractGeneratorHostKeyProvider() {
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path2) {
        this.path = path2 == null ? null : path2.toAbsolutePath();
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public AlgorithmParameterSpec getKeySpec() {
        return this.keySpec;
    }

    public void setKeySpec(AlgorithmParameterSpec keySpec) {
        this.keySpec = keySpec;
    }

    public boolean isOverwriteAllowed() {
        return this.overwriteAllowed;
    }

    public void setOverwriteAllowed(boolean overwriteAllowed) {
        this.overwriteAllowed = overwriteAllowed;
    }

    public boolean hasStrictFilePermissions() {
        return this.enforceFilePermissions;
    }

    public void setStrictFilePermissions(boolean strict) {
        this.enforceFilePermissions = strict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLoadedKeys() {
        Iterable ids;
        AtomicReference<Iterable<KeyPair>> atomicReference = this.keyPairHolder;
        synchronized (atomicReference) {
            ids = this.keyPairHolder.getAndSet(null);
        }
        if (ids != null && this.log.isDebugEnabled()) {
            this.log.debug("clearLoadedKeys({}) removed keys", (Object)this.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<KeyPair> loadKeys(SessionContext session2) {
        Iterable<KeyPair> ids;
        Path keyPath = this.getPath();
        AtomicReference<Iterable<KeyPair>> atomicReference = this.keyPairHolder;
        synchronized (atomicReference) {
            ids = this.keyPairHolder.get();
            if (ids == null) {
                try {
                    ids = this.resolveKeyPairs(session2, keyPath);
                    if (ids != null) {
                        this.keyPairHolder.set(ids);
                    }
                }
                catch (Exception t2) {
                    this.warn("loadKeys({}) Failed ({}) to resolve: {}", keyPath, t2.getClass().getSimpleName(), t2.getMessage(), t2);
                }
            }
        }
        ArrayList<KeyPair> pairs2 = Collections.emptyList();
        if (ids instanceof List) {
            pairs2 = (ArrayList<KeyPair>)ids;
        } else if (ids != null) {
            pairs2 = new ArrayList<KeyPair>();
            for (KeyPair kp : ids) {
                if (kp == null) continue;
                pairs2.add(kp);
            }
        }
        return pairs2;
    }

    protected Iterable<KeyPair> resolveKeyPairs(SessionContext session2, Path keyPath) throws IOException, GeneralSecurityException {
        String alg = this.getAlgorithm();
        if (keyPath != null) {
            try {
                Iterable<KeyPair> ids = this.loadFromFile(session2, alg, keyPath);
                KeyPair kp = GenericUtils.head(ids);
                if (kp != null) {
                    return ids;
                }
            }
            catch (Exception e2) {
                this.warn("resolveKeyPair({}) Failed ({}) to load: {}", keyPath, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            }
        }
        KeyPair kp = null;
        try {
            kp = this.generateKeyPair(alg);
            if (kp == null) {
                return null;
            }
            if (this.log.isDebugEnabled()) {
                PublicKey key2 = kp.getPublic();
                this.log.debug("resolveKeyPair({}) generated {} key={}-{}", keyPath, alg, KeyUtils.getKeyType(key2), KeyUtils.getFingerPrint(key2));
            }
        }
        catch (Exception e3) {
            this.warn("resolveKeyPair({})[{}] Failed ({}) to generate {} key-pair: {}", keyPath, alg, e3.getClass().getSimpleName(), alg, e3.getMessage(), e3);
            return null;
        }
        if (keyPath != null) {
            try {
                this.writeKeyPair(kp, keyPath);
            }
            catch (Exception e4) {
                this.warn("resolveKeyPair({})[{}] Failed ({}) to write {} key: {}", alg, keyPath, e4.getClass().getSimpleName(), alg, e4.getMessage(), e4);
            }
        }
        return Collections.singletonList(kp);
    }

    protected Iterable<KeyPair> loadFromFile(SessionContext session2, String alg, Path keyPath) throws IOException, GeneralSecurityException {
        LinkOption[] options2 = IoUtils.getLinkOptions(true);
        if (!Files.exists(keyPath, options2) || !Files.isRegularFile(keyPath, options2)) {
            return null;
        }
        Iterable<KeyPair> ids = this.readKeyPairs(session2, keyPath, IoUtils.EMPTY_OPEN_OPTIONS);
        KeyPair kp = GenericUtils.head(ids);
        if (kp == null) {
            return null;
        }
        PublicKey key2 = kp.getPublic();
        String keyAlgorithm = key2.getAlgorithm();
        if ("ECDSA".equalsIgnoreCase(keyAlgorithm)) {
            keyAlgorithm = DEFAULT_ALGORITHM;
        }
        if (Objects.equals(alg, keyAlgorithm) || this.edDSAAlgorithmsMatch(alg, keyAlgorithm)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveKeyPair({}) loaded key={}-{}", keyPath, KeyUtils.getKeyType(key2), KeyUtils.getFingerPrint(key2));
            }
            return ids;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveKeyPair({}) mismatched loaded key algorithm: expected={}, loaded={}", keyPath, alg, keyAlgorithm);
        }
        Files.deleteIfExists(keyPath);
        return null;
    }

    protected Iterable<KeyPair> readKeyPairs(SessionContext session2, Path keyPath, OpenOption ... options2) throws IOException, GeneralSecurityException {
        PathResource location = new PathResource(keyPath, options2);
        try (InputStream inputStream2 = location.openInputStream();){
            Iterable<KeyPair> iterable = this.doReadKeyPairs(session2, location, inputStream2);
            return iterable;
        }
    }

    protected Iterable<KeyPair> doReadKeyPairs(SessionContext session2, NamedResource resourceKey, InputStream inputStream2) throws IOException, GeneralSecurityException {
        return SecurityUtils.loadKeyPairIdentities(session2, resourceKey, inputStream2, null);
    }

    protected void writeKeyPair(KeyPair kp, Path keyPath) throws IOException, GeneralSecurityException {
        Objects.requireNonNull(kp, "No host key");
        if (!Files.exists(keyPath, new LinkOption[0]) || this.isOverwriteAllowed()) {
            Files.newOutputStream(keyPath, new OpenOption[0]).close();
            if (this.enforceFilePermissions) {
                this.setFilePermissions(keyPath);
            }
            try (OutputStream os = Files.newOutputStream(keyPath, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                this.doWriteKeyPair(new PathResource(keyPath), kp, os);
            }
            catch (Exception e2) {
                this.error("writeKeyPair({}) failed ({}) to write {} host key : {}", keyPath, e2.getClass().getSimpleName(), KeyUtils.getKeyType(kp), e2.getMessage(), e2);
            }
        } else {
            this.log.warn("Overwriting host key ({}) is disabled: using throwaway {} key: {}", keyPath, KeyUtils.getKeyType(kp), KeyUtils.getFingerPrint(kp.getPublic()));
        }
    }

    protected void setFilePermissions(Path path2) throws IOException {
        Exception t2 = null;
        if (OsUtils.isWin32()) {
            AclFileAttributeView view = Files.getFileAttributeView(path2, AclFileAttributeView.class, new LinkOption[0]);
            UserPrincipal owner = Files.getOwner(path2, new LinkOption[0]);
            if (view != null && owner != null) {
                try {
                    ArrayList<AclEntry> restricted = new ArrayList<AclEntry>();
                    for (AclEntry acl : view.getAcl()) {
                        if (owner.equals(acl.principal()) || AclEntryType.ALLOW.equals((Object)acl.type())) continue;
                        restricted.add(acl);
                    }
                    restricted.add(AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(owner).setPermissions(EnumSet.allOf(AclEntryPermission.class)).build());
                    view.setAcl(restricted);
                    return;
                }
                catch (IOException | SecurityException e2) {
                    t2 = e2;
                }
            }
        } else {
            File file2 = path2.toFile();
            if (!file2.setExecutable(false)) {
                this.log.debug("Host key file {}: cannot set non-executable", (Object)path2);
            }
            boolean success = file2.setWritable(false, false) && file2.setWritable(true, true);
            boolean bl = success = file2.setReadable(false, false) && file2.setReadable(true, true) && success;
            if (success) {
                return;
            }
        }
        this.log.warn("Host key file {}: cannot set file permissions correctly (readable and writeable only by owner)", (Object)path2, (Object)t2);
    }

    protected abstract void doWriteKeyPair(NamedResource var1, KeyPair var2, OutputStream var3) throws IOException, GeneralSecurityException;

    protected KeyPair generateKeyPair(String algorithm) throws GeneralSecurityException {
        KeyPairGenerator generator = SecurityUtils.getKeyPairGenerator(algorithm);
        if (this.keySpec != null) {
            generator.initialize(this.keySpec);
            this.log.info("generateKeyPair({}) generating host key - spec={}", (Object)algorithm, (Object)this.keySpec.getClass().getSimpleName());
        } else if (DEFAULT_ALGORITHM.equals(algorithm)) {
            ECCurves curve;
            if (this.keySize == 0) {
                int numCurves = ECCurves.SORTED_KEY_SIZE.size();
                curve = ECCurves.SORTED_KEY_SIZE.get(numCurves - 1);
            } else {
                curve = ECCurves.fromCurveSize(this.keySize);
                if (curve == null) {
                    throw new InvalidKeyException("No match found for curve with key size=" + this.keySize);
                }
            }
            generator.initialize(curve.getParameters());
            this.log.info("generateKeyPair({}) generating host key={}", (Object)algorithm, (Object)curve);
        } else if (this.keySize != 0) {
            generator.initialize(this.keySize);
            this.log.info("generateKeyPair({}) generating host key - size={}", (Object)algorithm, (Object)this.keySize);
        } else {
            this.log.info("generateKeyPair({}) generating host key", (Object)algorithm);
        }
        return generator.generateKeyPair();
    }

    boolean edDSAAlgorithmsMatch(String expectedAlgorithm, String keyAlgorithm) {
        return !(!expectedAlgorithm.equalsIgnoreCase("EdDSA") && !expectedAlgorithm.equalsIgnoreCase("Ed25519") || !keyAlgorithm.equalsIgnoreCase("EdDSA") && !keyAlgorithm.equalsIgnoreCase("Ed25519"));
    }
}

