/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyRandomArt;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.AsyncAuthException;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.UserAuthFactory;
import org.apache.sshd.server.auth.WelcomeBannerPhase;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionHolder;

public class ServerUserAuthService
extends AbstractCloseable
implements Service,
ServerSessionHolder {
    private final AtomicBoolean welcomeSent = new AtomicBoolean(false);
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final ServerSession serverSession;
    private final WelcomeBannerPhase welcomePhase;
    private List<UserAuthFactory> userAuthFactories;
    private List<List<String>> authMethods;
    private String authUserName;
    private String authMethod;
    private String authService;
    private UserAuth currentAuth;
    private int maxAuthRequests;
    private int nbAuthRequests;

    public ServerUserAuthService(Session s2) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        this.serverSession = ValidateUtils.checkInstanceOf((Object)s2, ServerSession.class, "Server side service used on client side: %s", (Object)s2);
        if (s2.isAuthenticated()) {
            throw new SshException("Session already authenticated");
        }
        this.welcomePhase = CoreModuleProperties.WELCOME_BANNER_PHASE.getRequired(this);
        this.maxAuthRequests = CoreModuleProperties.MAX_AUTH_REQUESTS.getRequired(this);
        List<UserAuthFactory> factories = ValidateUtils.checkNotNullAndNotEmpty(this.serverSession.getUserAuthFactories(), "No user auth factories for %s", s2);
        this.userAuthFactories = new ArrayList<UserAuthFactory>(factories);
        this.authMethods = new ArrayList<List<String>>();
        String mths = CoreModuleProperties.AUTH_METHODS.getOrNull(this);
        if (GenericUtils.isEmpty(mths)) {
            for (UserAuthFactory userAuthFactory : factories) {
                this.authMethods.add(new ArrayList<String>(Collections.singletonList(userAuthFactory.getName())));
            }
        } else {
            if (debugEnabled) {
                this.log.debug("ServerUserAuthService({}) using configured methods={}", (Object)s2, (Object)mths);
            }
            for (String mthl : mths.split("\\s")) {
                this.authMethods.add(new ArrayList<String>(Arrays.asList(GenericUtils.split(mthl, ','))));
            }
        }
        for (List list : this.authMethods) {
            for (String m4 : list) {
                UserAuthFactory factory2 = NamedResource.findByName(m4, String.CASE_INSENSITIVE_ORDER, this.userAuthFactories);
                if (factory2 != null) continue;
                throw new SshException("Configured method is not supported: " + m4);
            }
        }
        if (debugEnabled) {
            this.log.debug("ServerUserAuthService({}) authorized authentication methods: {}", (Object)s2, (Object)NamedResource.getNames(this.userAuthFactories));
        }
        s2.resetAuthTimeout();
    }

    public WelcomeBannerPhase getWelcomePhase() {
        return this.welcomePhase;
    }

    @Override
    public void start() {
    }

    @Override
    public ServerSession getSession() {
        return this.getServerSession();
    }

    @Override
    public ServerSession getServerSession() {
        return this.serverSession;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public synchronized void process(int cmd, Buffer buffer) throws Exception {
        Boolean authed = Boolean.FALSE;
        ServerSession session2 = this.getServerSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (cmd == 50) {
            AtomicReference<Boolean> authHolder = new AtomicReference<Boolean>(authed);
            if (!this.handleUserAuthRequestMessage(session2, buffer, authHolder)) {
                return;
            }
            authed = authHolder.get();
        } else {
            if (WelcomeBannerPhase.FIRST_AUTHCMD.equals((Object)this.getWelcomePhase())) {
                this.sendWelcomeBanner(session2);
            }
            if (this.currentAuth == null) {
                throw new IllegalStateException("No current authentication mechanism for cmd=" + SshConstants.getCommandMessageName(cmd));
            }
            if (debugEnabled) {
                this.log.debug("process({}) Received authentication message={} for mechanism={}", session2, SshConstants.getCommandMessageName(cmd), this.currentAuth.getName());
            }
            buffer.rpos(buffer.rpos() - 1);
            try {
                authed = this.currentAuth.next(buffer);
            }
            catch (AsyncAuthException async) {
                async.addListener(authenticated -> this.asyncAuth(cmd, buffer, (boolean)authenticated));
                return;
            }
            catch (Exception e2) {
                this.warn("process({}) Failed ({}) to authenticate using current method={}: {}", session2, e2.getClass().getSimpleName(), this.currentAuth.getName(), e2.getMessage(), e2);
            }
        }
        if (authed == null) {
            this.handleAuthenticationInProgress(cmd, buffer);
        } else if (authed.booleanValue()) {
            this.handleAuthenticationSuccess(cmd, buffer);
        } else {
            this.handleAuthenticationFailure(cmd, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleUserAuthRequestMessage(ServerSession session2, Buffer buffer, AtomicReference<Boolean> authHolder) throws Exception {
        UserAuthFactory factory2;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (session2.isAuthenticated()) {
            String username = buffer.getString();
            String service = buffer.getString();
            String method2 = buffer.getString();
            if (debugEnabled) {
                this.log.debug("handleUserAuthRequestMessage({}) ignore user={}, service={}, method={} auth. request since session already authenticated", session2, username, service, method2);
            }
            return false;
        }
        if (WelcomeBannerPhase.FIRST_REQUEST.equals((Object)this.getWelcomePhase())) {
            this.sendWelcomeBanner(session2);
        }
        if (this.currentAuth != null) {
            try {
                this.currentAuth.destroy();
            }
            finally {
                this.currentAuth = null;
            }
        }
        String username = buffer.getString();
        String service = buffer.getString();
        String method3 = buffer.getString();
        if (debugEnabled) {
            this.log.debug("handleUserAuthRequestMessage({}) Received SSH_MSG_USERAUTH_REQUEST user={}, service={}, method={}", session2, username, service, method3);
        }
        if (this.authUserName == null || this.authService == null) {
            this.authUserName = username;
            this.authService = service;
        } else if (this.authUserName.equals(username) && this.authService.equals(service)) {
            ++this.nbAuthRequests;
            if (this.nbAuthRequests > this.maxAuthRequests) {
                boolean disconnectSession = true;
                try {
                    SessionDisconnectHandler handler2 = session2.getSessionDisconnectHandler();
                    disconnectSession = handler2 == null || !handler2.handleAuthCountDisconnectReason(session2, this, service, method3, username, this.nbAuthRequests, this.maxAuthRequests);
                }
                catch (IOException | RuntimeException e2) {
                    this.warn("handleUserAuthRequestMessage({}) failed ({}) to invoke disconnect handler due to user={}/{}, service={}/{} - {}/{} auth requests: {}", session2, e2.getClass().getSimpleName(), this.authUserName, username, this.authService, service, this.nbAuthRequests, this.maxAuthRequests, e2.getMessage(), e2);
                }
                if (disconnectSession) {
                    session2.disconnect(2, "Too many authentication failures: " + this.nbAuthRequests);
                    return false;
                }
                if (debugEnabled) {
                    this.log.debug("handleUserAuthRequestMessage({}) ignore mismatched authentication counts: user={}/{}, service={}/{}: {}/{}", session2, this.authUserName, username, this.authService, service, this.nbAuthRequests, this.maxAuthRequests);
                }
            }
        } else {
            boolean disconnectSession = true;
            try {
                SessionDisconnectHandler handler3 = session2.getSessionDisconnectHandler();
                disconnectSession = handler3 == null || !handler3.handleAuthParamsDisconnectReason(session2, this, this.authUserName, username, this.authService, service);
            }
            catch (IOException | RuntimeException e3) {
                this.warn("handleUserAuthRequestMessage({}) failed ({}) to invoke disconnect handler due to user={}/{}, service={}/{} mismatched parameters: {}", session2, e3.getClass().getSimpleName(), this.authUserName, username, this.authService, service, e3.getMessage(), e3);
            }
            if (disconnectSession) {
                session2.disconnect(2, "Change of username or service is not allowed (" + this.authUserName + ", " + this.authService + ") -> (" + username + ", " + service + ")");
            } else if (debugEnabled) {
                this.log.debug("handleUserAuthRequestMessage({}) ignore mismatched authentication parameters: user={}/{}, service={}/{}", session2, this.authUserName, username, this.authService, service);
            }
            return false;
        }
        this.authMethod = method3;
        if (debugEnabled) {
            this.log.debug("handleUserAuthRequestMessage({}) Authenticating user '{}' with service '{}' and method '{}' (attempt {} / {})", session2, username, service, method3, this.nbAuthRequests, this.maxAuthRequests);
        }
        if ((factory2 = NamedResource.findByName(method3, String.CASE_INSENSITIVE_ORDER, this.userAuthFactories)) == null) {
            if (debugEnabled) {
                this.log.debug("handleUserAuthRequestMessage({}) no authentication factory for method={}", (Object)session2, (Object)method3);
            }
            return true;
        }
        this.currentAuth = ValidateUtils.checkNotNull((UserAuth)factory2.createUserAuth(session2), "No authenticator created for method=%s", (Object)method3);
        try {
            Boolean authed = this.currentAuth.auth(session2, username, service, buffer);
            authHolder.set(authed);
        }
        catch (AsyncAuthException async) {
            async.addListener(authenticated -> this.asyncAuth(50, buffer, (boolean)authenticated));
            return false;
        }
        catch (Exception e4) {
            this.warn("handleUserAuthRequestMessage({}) Failed ({}) to authenticate using factory method={}: {}", session2, e4.getClass().getSimpleName(), method3, e4.getMessage(), e4);
        }
        return true;
    }

    protected synchronized void asyncAuth(int cmd, Buffer buffer, boolean authed) {
        try {
            if (authed) {
                this.handleAuthenticationSuccess(cmd, buffer);
            } else {
                this.handleAuthenticationFailure(cmd, buffer);
            }
        }
        catch (Exception e2) {
            ServerSession session2 = this.getServerSession();
            this.warn("asyncAuth({}) Error ({}) performing async authentication via cmd={}: {}", session2, e2.getClass().getSimpleName(), cmd, e2.getMessage(), e2);
        }
    }

    protected void handleAuthenticationInProgress(int cmd, Buffer buffer) throws Exception {
        String username;
        String string = username = this.currentAuth == null ? null : this.currentAuth.getUsername();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleAuthenticationInProgress({}@{}) {}", username, this.getServerSession(), SshConstants.getCommandMessageName(cmd));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAuthenticationSuccess(int cmd, Buffer buffer) throws Exception {
        String username = Objects.requireNonNull(this.currentAuth, "No current auth").getUsername();
        ServerSession session2 = this.getServerSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("handleAuthenticationSuccess({}@{}) {}", username, session2, SshConstants.getCommandMessageName(cmd));
        }
        boolean success = false;
        for (List<String> l2 : this.authMethods) {
            if (GenericUtils.size(l2) <= 0 || !l2.get(0).equals(this.authMethod)) continue;
            l2.remove(0);
            success |= l2.isEmpty();
        }
        if (success) {
            int currentSessionCount;
            Integer maxSessionCount = CoreModuleProperties.MAX_CONCURRENT_SESSIONS.getOrNull(session2);
            if (maxSessionCount != null && (currentSessionCount = session2.getActiveSessionCountForUser(username)) >= maxSessionCount) {
                boolean disconnectSession = true;
                try {
                    SessionDisconnectHandler handler2 = session2.getSessionDisconnectHandler();
                    disconnectSession = handler2 == null || !handler2.handleSessionsCountDisconnectReason(session2, this, username, currentSessionCount, maxSessionCount);
                }
                catch (IOException | RuntimeException e2) {
                    this.warn("handleAuthenticationSuccess({}@{}) failed ({}) to invoke disconnect handler due to {}/{} sessions count: {}", username, session2, e2.getClass().getSimpleName(), currentSessionCount, maxSessionCount, e2.getMessage(), e2);
                }
                if (disconnectSession) {
                    session2.disconnect(12, "Too many concurrent connections (" + currentSessionCount + ") - max. allowed: " + maxSessionCount);
                    return;
                }
                if (debugEnabled) {
                    this.log.debug("handleAuthenticationSuccess({}@{}) ignore {}/{} sessions count due to handler intervention", username, session2, currentSessionCount, maxSessionCount);
                }
            }
            if (WelcomeBannerPhase.POST_SUCCESS.equals((Object)this.getWelcomePhase())) {
                this.sendWelcomeBanner(session2);
            }
            session2.signalAuthenticationSuccess(username, this.authService, buffer);
        } else {
            String remaining = this.authMethods.stream().filter(GenericUtils::isNotEmpty).map(l -> (String)l.get(0)).collect(Collectors.joining(","));
            if (debugEnabled) {
                this.log.debug("handleAuthenticationSuccess({}@{}) remaining methods={}", username, session2, remaining);
            }
            Buffer response2 = session2.createBuffer((byte)51, remaining.length() + 8);
            response2.putString(remaining);
            response2.putBoolean(true);
            session2.writePacket(response2);
        }
        try {
            this.currentAuth.destroy();
        }
        finally {
            this.currentAuth = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAuthenticationFailure(int cmd, Buffer buffer) throws Exception {
        String username;
        ServerSession session2 = this.getServerSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (WelcomeBannerPhase.FIRST_FAILURE.equals((Object)this.getWelcomePhase())) {
            this.sendWelcomeBanner(session2);
        }
        String string = username = this.currentAuth == null ? null : this.currentAuth.getUsername();
        if (debugEnabled) {
            this.log.debug("handleAuthenticationFailure({}@{}) {}", username, session2, SshConstants.getCommandMessageName(cmd));
        }
        StringBuilder sb = new StringBuilder((this.authMethods.size() + 1) * 8);
        for (List<String> l : this.authMethods) {
            String m4;
            if (GenericUtils.size(l) <= 0 || "none".equals(m4 = l.get(0))) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(m4);
        }
        String remaining = sb.toString();
        if (debugEnabled) {
            this.log.debug("handleAuthenticationFailure({}@{}) remaining methods: {}", username, session2, remaining);
        }
        buffer = session2.createBuffer((byte)51, remaining.length() + 8);
        buffer.putString(remaining);
        buffer.putBoolean(false);
        session2.writePacket(buffer);
        if (this.currentAuth != null) {
            try {
                this.currentAuth.destroy();
            }
            finally {
                this.currentAuth = null;
            }
        }
    }

    public IoWriteFuture sendWelcomeBanner(ServerSession session2) throws IOException {
        if (this.welcomeSent.getAndSet(true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendWelcomeBanner({}) already sent", (Object)session2);
            }
            return null;
        }
        String welcomeBanner = this.resolveWelcomeBanner(session2);
        if (GenericUtils.isEmpty(welcomeBanner)) {
            return null;
        }
        String lang = CoreModuleProperties.WELCOME_BANNER_LANGUAGE.getRequired(this);
        Buffer buffer = session2.createBuffer((byte)53, welcomeBanner.length() + GenericUtils.length(lang) + 64);
        buffer.putString(welcomeBanner);
        buffer.putString(lang);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendWelcomeBanner({}) send banner (length={}, lang={})", session2, welcomeBanner.length(), lang);
        }
        return session2.writePacket(buffer);
    }

    protected String resolveWelcomeBanner(ServerSession session2) throws IOException {
        Object bannerValue = CoreModuleProperties.WELCOME_BANNER.getOrNull(this);
        if (bannerValue == null) {
            return null;
        }
        if (bannerValue instanceof CharSequence) {
            String message = bannerValue.toString();
            if (GenericUtils.isEmpty(message)) {
                return null;
            }
            if ("#auto-welcome-banner".equalsIgnoreCase(message)) {
                try {
                    return KeyRandomArt.combine(session2, ' ', session2.getKeyPairProvider());
                }
                catch (IOException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new IOException(e3);
                }
            }
            if (!message.contains("://")) {
                return message;
            }
            try {
                bannerValue = new URI(message);
            }
            catch (URISyntaxException e4) {
                this.log.error("resolveWelcomeBanner({}) bad path URI {}: {}", session2, message, e4.getMessage());
                throw new MalformedURLException(e4.getClass().getSimpleName() + " - bad URI (" + message + "): " + e4.getMessage());
            }
            if (message.startsWith("file:/")) {
                bannerValue = Paths.get((URI)bannerValue);
            }
        }
        if (bannerValue instanceof File) {
            bannerValue = ((File)bannerValue).toPath();
        }
        if (bannerValue instanceof Path) {
            Path path2 = (Path)bannerValue;
            if (!Files.exists(path2, new LinkOption[0]) || Files.size(path2) <= 0L) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("resolveWelcomeBanner({}) file is empty/does not exist {}", (Object)session2, (Object)path2);
                }
                return null;
            }
            bannerValue = path2.toUri();
        }
        if (bannerValue instanceof URI) {
            bannerValue = ((URI)bannerValue).toURL();
        }
        if (bannerValue instanceof URL) {
            Charset cs = CoreModuleProperties.WELCOME_BANNER_CHARSET.getRequired(this);
            return this.loadWelcomeBanner(session2, (URL)bannerValue, cs);
        }
        return bannerValue.toString();
    }

    protected String loadWelcomeBanner(ServerSession session2, URL url2, Charset cs) throws IOException {
        try (InputStream stream = url2.openStream();){
            byte[] bytes = IoUtils.toByteArray(stream);
            String string = NumberUtils.isEmpty(bytes) ? "" : new String(bytes, cs);
            return string;
        }
    }

    public ServerFactoryManager getFactoryManager() {
        return this.serverSession.getFactoryManager();
    }
}

