/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.shell.InteractiveProcessShellFactory;
import org.apache.sshd.server.shell.ShellFactory;
import org.apache.sshd.server.shell.ShellFactorySelector;

public class AggregateShellFactory
extends AbstractLoggingBean
implements ShellFactory,
ShellFactorySelector {
    protected final ShellFactory defaultFactory;
    protected final Collection<? extends ShellFactorySelector> selectors;

    public AggregateShellFactory(Collection<? extends ShellFactorySelector> selectors) {
        this(selectors, InteractiveProcessShellFactory.INSTANCE);
    }

    public AggregateShellFactory(Collection<? extends ShellFactorySelector> selectors, ShellFactory defaultFactory) {
        this.selectors = selectors == null ? Collections.emptyList() : selectors;
        this.defaultFactory = Objects.requireNonNull(defaultFactory, "No default factory provided");
    }

    @Override
    public Command createShell(ChannelSession channel2) throws IOException {
        ShellFactory factory2 = this.selectShellFactory(channel2);
        if (factory2 == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("createShell({}) using default factory={}", (Object)channel2, (Object)this.defaultFactory);
            }
            factory2 = this.defaultFactory;
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("createShell({}) using selected factory={}", (Object)channel2, (Object)factory2);
        }
        return factory2.createShell(channel2);
    }

    @Override
    public ShellFactory selectShellFactory(ChannelSession channel2) throws IOException {
        return ShellFactorySelector.selectShellFactory(this.selectors, channel2);
    }
}

